/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.filters;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import net.sf.samtools.SAMFileHeader;
import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.exceptions.UserException;

public class RemappingFilter
extends ReadFilter {
    Map<String, String> mapping;
    SAMFileHeader oldHeader;
    SAMFileHeader newHeader;

    public RemappingFilter(Map<String, String> mapping, SAMFileHeader oldHeader, SAMFileHeader newHeader) {
        this.mapping = mapping;
        this.newHeader = newHeader;
        this.oldHeader = oldHeader;
    }

    @Override
    public boolean filterOut(SAMRecord samRecord) {
        samRecord.setHeader(this.newHeader);
        if (this.mapping == null) {
            return true;
        }
        String curContig = samRecord.getReferenceName();
        if (this.mapping.containsKey(curContig)) {
            samRecord.setReferenceIndex(this.newHeader.getSequenceIndex(this.mapping.get(curContig)));
        } else {
            samRecord.setReferenceIndex(-1);
            samRecord.setMappingQuality(0);
        }
        curContig = samRecord.getMateReferenceName();
        if (this.mapping.containsKey(curContig)) {
            samRecord.setMateReferenceIndex(this.newHeader.getSequenceIndex(this.mapping.get(curContig)));
        } else {
            samRecord.setMateReferenceIndex(-1);
            samRecord.setMateUnmappedFlag(true);
            samRecord.setMateAlignmentStart(0);
        }
        return true;
    }

    public static class RemappingFile {
        private final Map<String, String> remapping = new HashMap<String, String>();

        public RemappingFile(String remappingFile) {
            File remapFl = new File(remappingFile);
            if (!remapFl.exists()) {
                throw new UserException.BadInput("File " + remappingFile + " doesn't exist");
            }
            try {
                BufferedReader input = new BufferedReader(new FileReader(remapFl));
                String line = null;
                while ((line = input.readLine()) != null) {
                    String[] split = line.split("\t");
                    if (split.length != 2) {
                        throw new UserException.BadInput("line " + line + " didn't split into the required two pieces (current contig and new contig)");
                    }
                    this.remapping.put(split[0], split[1]);
                }
            }
            catch (FileNotFoundException e) {
                throw new UserException.BadInput("File " + remappingFile + " couldn't be read");
            }
            catch (IOException e) {
                throw new UserException.BadInput("File " + remappingFile + " couldn't be read");
            }
        }

        public Map<String, String> getRemapping() {
            return this.remapping;
        }
    }
}

