/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.recalibration;

import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.broadinstitute.sting.gatk.report.GATKReport;
import org.broadinstitute.sting.gatk.report.GATKReportTable;
import org.broadinstitute.sting.gatk.walkers.bqsr.RecalibrationArgumentCollection;
import org.broadinstitute.sting.utils.collections.NestedIntegerArray;
import org.broadinstitute.sting.utils.collections.Pair;
import org.broadinstitute.sting.utils.recalibration.EventType;
import org.broadinstitute.sting.utils.recalibration.QuantizationInfo;
import org.broadinstitute.sting.utils.recalibration.RecalDatum;
import org.broadinstitute.sting.utils.recalibration.RecalUtils;
import org.broadinstitute.sting.utils.recalibration.RecalibrationTables;
import org.broadinstitute.sting.utils.recalibration.covariates.Covariate;

public class RecalibrationReport {
    private QuantizationInfo quantizationInfo;
    private final RecalibrationTables recalibrationTables;
    private final Covariate[] requestedCovariates;
    private final HashMap<String, Integer> optionalCovariateIndexes;
    private final GATKReportTable argumentTable;
    private final RecalibrationArgumentCollection RAC;
    private final int[] tempRGarray = new int[2];
    private final int[] tempQUALarray = new int[3];
    private final int[] tempCOVarray = new int[4];

    public RecalibrationReport(File RECAL_FILE) {
        GATKReport report = new GATKReport(RECAL_FILE);
        this.argumentTable = report.getTable("Arguments");
        this.RAC = this.initializeArgumentCollectionTable(this.argumentTable);
        GATKReportTable quantizedTable = report.getTable("Quantized");
        this.quantizationInfo = this.initializeQuantizationTable(quantizedTable);
        Pair<ArrayList<Covariate>, ArrayList<Covariate>> covariates = RecalUtils.initializeCovariates(this.RAC);
        ArrayList<Covariate> requiredCovariates = covariates.getFirst();
        ArrayList<Covariate> optionalCovariates = covariates.getSecond();
        this.requestedCovariates = new Covariate[requiredCovariates.size() + optionalCovariates.size()];
        this.optionalCovariateIndexes = new HashMap(optionalCovariates.size());
        int covariateIndex = 0;
        for (Covariate covariate : requiredCovariates) {
            this.requestedCovariates[covariateIndex++] = covariate;
        }
        Iterator<Covariate> i$ = optionalCovariates.iterator();
        while (i$.hasNext()) {
            Covariate covariate;
            this.requestedCovariates[covariateIndex] = covariate = i$.next();
            String covariateName = covariate.getClass().getSimpleName().split("Covariate")[0];
            this.optionalCovariateIndexes.put(covariateName, covariateIndex - 2);
            ++covariateIndex;
        }
        for (Covariate cov : this.requestedCovariates) {
            cov.initialize(this.RAC);
        }
        this.recalibrationTables = new RecalibrationTables(this.requestedCovariates, this.countReadGroups(report.getTable("RecalTable0")));
        this.parseReadGroupTable(report.getTable("RecalTable0"), this.recalibrationTables.getTable(RecalibrationTables.TableType.READ_GROUP_TABLE));
        this.parseQualityScoreTable(report.getTable("RecalTable1"), this.recalibrationTables.getTable(RecalibrationTables.TableType.QUALITY_SCORE_TABLE));
        this.parseAllCovariatesTable(report.getTable("RecalTable2"), this.recalibrationTables);
    }

    protected RecalibrationReport(QuantizationInfo quantizationInfo, RecalibrationTables recalibrationTables, GATKReportTable argumentTable, RecalibrationArgumentCollection RAC) {
        this.quantizationInfo = quantizationInfo;
        this.recalibrationTables = recalibrationTables;
        this.argumentTable = argumentTable;
        this.RAC = RAC;
        this.requestedCovariates = null;
        this.optionalCovariateIndexes = null;
    }

    private int countReadGroups(GATKReportTable reportTable) {
        HashSet<String> readGroups = new HashSet<String>();
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            readGroups.add(reportTable.get(i, "ReadGroup").toString());
        }
        return readGroups.size();
    }

    public void combine(RecalibrationReport other) {
        for (RecalibrationTables.TableType type : RecalibrationTables.TableType.values()) {
            NestedIntegerArray<RecalDatum> myTable = this.recalibrationTables.getTable(type);
            NestedIntegerArray<RecalDatum> otherTable = other.recalibrationTables.getTable(type);
            for (NestedIntegerArray.Leaf row : otherTable.getAllLeaves()) {
                RecalDatum myDatum = myTable.get(row.keys);
                if (myDatum == null) {
                    myTable.put((RecalDatum)row.value, row.keys);
                    continue;
                }
                myDatum.combine((RecalDatum)row.value);
            }
        }
    }

    public QuantizationInfo getQuantizationInfo() {
        return this.quantizationInfo;
    }

    public RecalibrationTables getRecalibrationTables() {
        return this.recalibrationTables;
    }

    public Covariate[] getRequestedCovariates() {
        return this.requestedCovariates;
    }

    private void parseAllCovariatesTable(GATKReportTable reportTable, RecalibrationTables recalibrationTables) {
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            Object rg = reportTable.get(i, "ReadGroup");
            this.tempCOVarray[0] = this.requestedCovariates[0].keyFromValue(rg);
            Object qual = reportTable.get(i, "QualityScore");
            this.tempCOVarray[1] = this.requestedCovariates[1].keyFromValue(qual);
            String covName = (String)reportTable.get(i, "CovariateName");
            int covIndex = this.optionalCovariateIndexes.get(covName);
            Object covValue = reportTable.get(i, "CovariateValue");
            this.tempCOVarray[2] = this.requestedCovariates[RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.index + covIndex].keyFromValue(covValue);
            EventType event = EventType.eventFrom((String)reportTable.get(i, "EventType"));
            this.tempCOVarray[3] = event.index;
            recalibrationTables.getTable(RecalibrationTables.TableType.OPTIONAL_COVARIATE_TABLES_START.index + covIndex).put(this.getRecalDatum(reportTable, i, false), this.tempCOVarray);
        }
    }

    private void parseQualityScoreTable(GATKReportTable reportTable, NestedIntegerArray<RecalDatum> qualTable) {
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            Object rg = reportTable.get(i, "ReadGroup");
            this.tempQUALarray[0] = this.requestedCovariates[0].keyFromValue(rg);
            Object qual = reportTable.get(i, "QualityScore");
            this.tempQUALarray[1] = this.requestedCovariates[1].keyFromValue(qual);
            EventType event = EventType.eventFrom((String)reportTable.get(i, "EventType"));
            this.tempQUALarray[2] = event.index;
            qualTable.put(this.getRecalDatum(reportTable, i, false), this.tempQUALarray);
        }
    }

    private void parseReadGroupTable(GATKReportTable reportTable, NestedIntegerArray<RecalDatum> rgTable) {
        for (int i = 0; i < reportTable.getNumRows(); ++i) {
            Object rg = reportTable.get(i, "ReadGroup");
            this.tempRGarray[0] = this.requestedCovariates[0].keyFromValue(rg);
            EventType event = EventType.eventFrom((String)reportTable.get(i, "EventType"));
            this.tempRGarray[1] = event.index;
            rgTable.put(this.getRecalDatum(reportTable, i, true), this.tempRGarray);
        }
    }

    private RecalDatum getRecalDatum(GATKReportTable reportTable, int row, boolean hasEstimatedQReportedColumn) {
        long nObservations = (Long)reportTable.get(row, "Observations");
        long nErrors = (Long)reportTable.get(row, "Errors");
        double empiricalQuality = (Double)reportTable.get(row, "EmpiricalQuality");
        double estimatedQReported = hasEstimatedQReportedColumn ? (Double)reportTable.get(row, "EstimatedQReported") : (double)Byte.parseByte((String)reportTable.get(row, "QualityScore"));
        RecalDatum datum = new RecalDatum(nObservations, nErrors, 1);
        datum.setEstimatedQReported(estimatedQReported);
        datum.setEmpiricalQuality(empiricalQuality);
        return datum;
    }

    private QuantizationInfo initializeQuantizationTable(GATKReportTable table) {
        Byte[] quals = new Byte[94];
        Long[] counts = new Long[94];
        for (int i = 0; i < table.getNumRows(); ++i) {
            byte originalQual = (byte)i;
            Object quantizedObject = table.get(i, "QuantizedScore");
            Object countObject = table.get(i, "Count");
            byte quantizedQual = Byte.parseByte(quantizedObject.toString());
            long quantizedCount = Long.parseLong(countObject.toString());
            quals[originalQual] = quantizedQual;
            counts[originalQual] = quantizedCount;
        }
        return new QuantizationInfo(Arrays.asList(quals), Arrays.asList(counts));
    }

    private RecalibrationArgumentCollection initializeArgumentCollectionTable(GATKReportTable table) {
        RecalibrationArgumentCollection RAC = new RecalibrationArgumentCollection();
        for (int i = 0; i < table.getNumRows(); ++i) {
            String argument = table.get(i, "Argument").toString();
            Object value = table.get(i, "Value");
            if (value.equals("null")) {
                value = null;
            }
            if (argument.equals("covariate") && value != null) {
                RAC.COVARIATES = value.toString().split(",");
                continue;
            }
            if (argument.equals("standard_covs")) {
                RAC.DO_NOT_USE_STANDARD_COVARIATES = Boolean.parseBoolean((String)value);
                continue;
            }
            if (argument.equals("solid_recal_mode")) {
                RAC.SOLID_RECAL_MODE = RecalUtils.SOLID_RECAL_MODE.recalModeFromString((String)value);
                continue;
            }
            if (argument.equals("solid_nocall_strategy")) {
                RAC.SOLID_NOCALL_STRATEGY = RecalUtils.SOLID_NOCALL_STRATEGY.nocallStrategyFromString((String)value);
                continue;
            }
            if (argument.equals("mismatches_context_size")) {
                RAC.MISMATCHES_CONTEXT_SIZE = Integer.parseInt((String)value);
                continue;
            }
            if (argument.equals("indels_context_size")) {
                RAC.INDELS_CONTEXT_SIZE = Integer.parseInt((String)value);
                continue;
            }
            if (argument.equals("mismatches_default_quality")) {
                RAC.MISMATCHES_DEFAULT_QUALITY = Byte.parseByte((String)value);
                continue;
            }
            if (argument.equals("insertions_default_quality")) {
                RAC.INSERTIONS_DEFAULT_QUALITY = Byte.parseByte((String)value);
                continue;
            }
            if (argument.equals("deletions_default_quality")) {
                RAC.DELETIONS_DEFAULT_QUALITY = Byte.parseByte((String)value);
                continue;
            }
            if (argument.equals("low_quality_tail")) {
                RAC.LOW_QUAL_TAIL = Byte.parseByte((String)value);
                continue;
            }
            if (argument.equals("default_platform")) {
                RAC.DEFAULT_PLATFORM = (String)value;
                continue;
            }
            if (argument.equals("force_platform")) {
                RAC.FORCE_PLATFORM = (String)value;
                continue;
            }
            if (argument.equals("quantizing_levels")) {
                RAC.QUANTIZING_LEVELS = Integer.parseInt((String)value);
                continue;
            }
            if (argument.equals("keep_intermediate_files")) {
                RAC.KEEP_INTERMEDIATE_FILES = Boolean.parseBoolean((String)value);
                continue;
            }
            if (argument.equals("no_plots")) {
                RAC.NO_PLOTS = Boolean.parseBoolean((String)value);
                continue;
            }
            if (argument.equals("recalibration_report")) {
                RAC.recalibrationReport = value == null ? null : new File((String)value);
                continue;
            }
            if (!argument.equals("binary_tag_name")) continue;
            RAC.BINARY_TAG_NAME = value == null ? null : (String)value;
        }
        return RAC;
    }

    public void calculateQuantizedQualities() {
        this.quantizationInfo = new QuantizationInfo(this.recalibrationTables, this.RAC.QUANTIZING_LEVELS);
    }

    public void output(PrintStream output) {
        RecalUtils.outputRecalibrationReport(this.argumentTable, this.quantizationInfo, this.recalibrationTables, this.requestedCovariates, output);
    }

    public RecalibrationArgumentCollection getRAC() {
        return this.RAC;
    }

    public Covariate[] getCovariates() {
        return this.requestedCovariates;
    }
}

