/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.gatk.traversals;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.ReadMetrics;
import org.broadinstitute.sting.gatk.datasources.providers.ShardDataProvider;
import org.broadinstitute.sting.gatk.datasources.reads.Shard;
import org.broadinstitute.sting.gatk.walkers.Walker;
import org.broadinstitute.sting.utils.AutoFormattingTime;
import org.broadinstitute.sting.utils.GenomeLoc;
import org.broadinstitute.sting.utils.GenomeLocSortedSet;
import org.broadinstitute.sting.utils.MathUtils;
import org.broadinstitute.sting.utils.SimpleTimer;
import org.broadinstitute.sting.utils.Utils;
import org.broadinstitute.sting.utils.exceptions.ReviewedStingException;
import org.broadinstitute.sting.utils.exceptions.UserException;

public abstract class TraversalEngine<M, T, WalkerType extends Walker<M, T>, ProviderType extends ShardDataProvider> {
    protected static final Logger logger = Logger.getLogger(TraversalEngine.class);
    private static final int HISTORY_WINDOW_SIZE = 50;
    private static final Object lock = new Object();
    LinkedList<ProcessingHistory> history = new LinkedList();
    private SimpleTimer timer = null;
    private long lastProgressPrintTime = -1L;
    private static final long MIN_ELAPSED_TIME_BEFORE_FIRST_PROGRESS = 30000L;
    private static final double TWO_HOURS_IN_SECONDS = 7200.0;
    private static final double TWELVE_HOURS_IN_SECONDS = 43200.0;
    private long progressPrintFrequency = 10000L;
    private boolean progressMeterInitialized = false;
    private static final boolean PERFORMANCE_LOG_ENABLED = true;
    private final Object performanceLogLock = new Object();
    private File performanceLogFile;
    private PrintStream performanceLog = null;
    private long lastPerformanceLogPrintTime = -1L;
    private final long PERFORMANCE_LOG_PRINT_FREQUENCY = this.progressPrintFrequency;
    long targetSize = -1L;
    GenomeLocSortedSet targetIntervals = null;
    protected GenomeAnalysisEngine engine;

    protected abstract String getTraversalType();

    public abstract T traverse(WalkerType var1, ProviderType var2, T var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(GenomeAnalysisEngine engine) {
        if (engine == null) {
            throw new ReviewedStingException("BUG: GenomeAnalysisEngine cannot be null!");
        }
        this.engine = engine;
        if (engine.getArguments() != null && engine.getArguments().performanceLog != null) {
            Object object = this.performanceLogLock;
            synchronized (object) {
                this.performanceLogFile = engine.getArguments().performanceLog;
                this.createNewPerformanceLog();
            }
        }
        this.targetIntervals = this.engine.getIntervals() == null ? GenomeLocSortedSet.createSetFromSequenceDictionary(engine.getReferenceDataSource().getReference().getSequenceDictionary()) : this.engine.getIntervals();
        this.targetSize = this.targetIntervals.coveredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createNewPerformanceLog() {
        Object object = this.performanceLogLock;
        synchronized (object) {
            try {
                this.performanceLog = new PrintStream(new FileOutputStream(this.engine.getArguments().performanceLog));
                List<String> pLogHeader = Arrays.asList("elapsed.time", "units.processed", "processing.speed", "bp.processed", "bp.speed", "genome.fraction.complete", "est.total.runtime", "est.time.remaining");
                this.performanceLog.println(Utils.join("\t", pLogHeader));
            }
            catch (FileNotFoundException e) {
                throw new UserException.CouldNotCreateOutputFile(this.engine.getArguments().performanceLog, (Exception)e);
            }
        }
    }

    public void startTimersIfNecessary() {
        if (this.timer == null) {
            this.timer = new SimpleTimer("Traversal");
            this.timer.start();
            this.lastProgressPrintTime = this.timer.currentTime();
        }
    }

    private boolean maxElapsedIntervalForPrinting(long curTime, long lastPrintTime, long printFreq) {
        long elapsed = curTime - lastPrintTime;
        return elapsed > printFreq && elapsed > 30000L;
    }

    public void updateCumulativeMetrics(Shard shard) {
        this.updateCumulativeMetrics(shard.getReadMetrics());
    }

    public void updateCumulativeMetrics(ReadMetrics singleTraverseMetrics) {
        this.engine.getCumulativeMetrics().incrementMetrics(singleTraverseMetrics);
    }

    public void printProgress(GenomeLoc loc) {
        this.printProgress(loc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void printProgress(GenomeLoc loc, boolean mustPrint) {
        boolean printLog;
        if (!this.progressMeterInitialized) {
            logger.info("[INITIALIZATION COMPLETE; TRAVERSAL STARTING]");
            logger.info(String.format("%15s processed.%s  runtime per.1M.%s completed total.runtime remaining", "Location", this.getTraversalType(), this.getTraversalType()));
            this.progressMeterInitialized = true;
        }
        long curTime = this.timer.currentTime();
        boolean printProgress = mustPrint || this.maxElapsedIntervalForPrinting(curTime, this.lastProgressPrintTime, this.progressPrintFrequency);
        boolean bl = printLog = this.performanceLog != null && this.maxElapsedIntervalForPrinting(curTime, this.lastPerformanceLogPrintTime, this.PERFORMANCE_LOG_PRINT_FREQUENCY);
        if (printProgress || printLog) {
            ProcessingHistory last = this.updateHistory(loc, this.engine.getCumulativeMetrics());
            AutoFormattingTime elapsed = new AutoFormattingTime(last.elapsedSeconds);
            AutoFormattingTime bpRate = new AutoFormattingTime(last.secondsPerMillionBP());
            AutoFormattingTime unitRate = new AutoFormattingTime(last.secondsPerMillionElements());
            double fractionGenomeTargetCompleted = last.calculateFractionGenomeTargetCompleted(this.targetSize);
            AutoFormattingTime estTotalRuntime = new AutoFormattingTime(elapsed.getTimeInSeconds() / fractionGenomeTargetCompleted);
            AutoFormattingTime timeToCompletion = new AutoFormattingTime(estTotalRuntime.getTimeInSeconds() - elapsed.getTimeInSeconds());
            long nRecords = this.engine.getCumulativeMetrics().getNumIterations();
            if (printProgress) {
                this.lastProgressPrintTime = curTime;
                this.progressPrintFrequency = estTotalRuntime.getTimeInSeconds() > 43200.0 ? 60000L : (estTotalRuntime.getTimeInSeconds() > 7200.0 ? 30000L : 10000L);
                String posName = loc == null ? (mustPrint ? "done" : "unmapped reads") : String.format("%s:%d", loc.getContig(), loc.getStart());
                logger.info(String.format("%15s        %5.2e %s     %s    %5.1f%%      %s  %s", posName, (double)nRecords * 1.0, elapsed, unitRate, 100.0 * fractionGenomeTargetCompleted, estTotalRuntime, timeToCompletion));
            }
            if (printLog) {
                this.lastPerformanceLogPrintTime = curTime;
                Object object = this.performanceLogLock;
                synchronized (object) {
                    this.performanceLog.printf("%.2f\t%d\t%.2e\t%d\t%.2e\t%.2e\t%.2f\t%.2f%n", elapsed.getTimeInSeconds(), nRecords, unitRate.getTimeInSeconds(), last.bpProcessed, bpRate.getTimeInSeconds(), fractionGenomeTargetCompleted, estTotalRuntime.getTimeInSeconds(), timeToCompletion.getTimeInSeconds());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProcessingHistory updateHistory(GenomeLoc loc, ReadMetrics metrics) {
        Object object = lock;
        synchronized (object) {
            if (this.history.size() > 50) {
                this.history.pop();
            }
            long nRecords = metrics.getNumIterations();
            long bpProcessed = loc == null ? this.targetSize : this.targetIntervals.sizeBeforeLoc(loc);
            this.history.add(new ProcessingHistory(this.timer.getElapsedTime(), loc, nRecords, bpProcessed));
            return this.history.getLast();
        }
    }

    public void printOnTraversalDone() {
        this.printProgress(null, true);
        double elapsed = this.timer == null ? 0.0 : this.timer.getElapsedTime();
        ReadMetrics cumulativeMetrics = this.engine.getCumulativeMetrics();
        long nSkippedReads = 0L;
        Iterator<Object> i$ = cumulativeMetrics.getCountsByFilter().values().iterator();
        while (i$.hasNext()) {
            long l = i$.next();
            nSkippedReads += l;
        }
        logger.info(String.format("Total runtime %.2f secs, %.2f min, %.2f hours", elapsed, elapsed / 60.0, elapsed / 3600.0));
        if (cumulativeMetrics.getNumReadsSeen() > 0L) {
            logger.info(String.format("%d reads were filtered out during traversal out of %d total (%.2f%%)", nSkippedReads, cumulativeMetrics.getNumReadsSeen(), 100.0 * MathUtils.ratio(nSkippedReads, cumulativeMetrics.getNumReadsSeen())));
        }
        for (Map.Entry entry : cumulativeMetrics.getCountsByFilter().entrySet()) {
            long count = (Long)entry.getValue();
            logger.info(String.format("  -> %d reads (%.2f%% of total) failing %s", count, 100.0 * MathUtils.ratio(count, cumulativeMetrics.getNumReadsSeen()), entry.getKey()));
        }
        if (this.performanceLog != null) {
            this.performanceLog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPerformanceLogFileName() {
        Object object = this.performanceLogLock;
        synchronized (object) {
            return this.performanceLogFile.getAbsolutePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPerformanceLogFileName(String fileName) {
        File file = new File(fileName);
        Object object = this.performanceLogLock;
        synchronized (object) {
            if (this.performanceLogFile != null && this.performanceLogFile.equals(file)) {
                return;
            }
            if (this.performanceLog != null) {
                this.performanceLog.close();
            }
            this.performanceLogFile = file;
            this.createNewPerformanceLog();
        }
    }

    public long getPerformanceProgressPrintFrequencySeconds() {
        return this.progressPrintFrequency;
    }

    public void setPerformanceProgressPrintFrequencySeconds(long seconds) {
        this.progressPrintFrequency = seconds;
    }

    private static class ProcessingHistory {
        double elapsedSeconds;
        long unitsProcessed;
        long bpProcessed;
        GenomeLoc loc;

        public ProcessingHistory(double elapsedSeconds, GenomeLoc loc, long unitsProcessed, long bpProcessed) {
            this.elapsedSeconds = elapsedSeconds;
            this.loc = loc;
            this.unitsProcessed = unitsProcessed;
            this.bpProcessed = bpProcessed;
        }

        private double secondsPerMillionElements() {
            return this.elapsedSeconds * 1000000.0 / (double)Math.max(this.unitsProcessed, 1L);
        }

        private double secondsPerMillionBP() {
            return this.elapsedSeconds * 1000000.0 / (double)Math.max(this.bpProcessed, 1L);
        }

        private double calculateFractionGenomeTargetCompleted(long targetSize) {
            return 1.0 * (double)this.bpProcessed / (double)targetSize;
        }
    }
}

