/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.walkers.cancer.mutect;

import java.io.PrintStream;
import net.sf.picard.util.FormatUtil;
import org.broadinstitute.sting.gatk.contexts.AlignmentContext;

public class CoverageWiggleFileWriter {
    protected PrintStream ps;
    private int lastContigIndex = -1;
    private long lastPosition = -1L;
    private final FormatUtil fmt = new FormatUtil();

    public CoverageWiggleFileWriter(PrintStream ps) {
        this(ps, "SomaticCoverage");
    }

    public CoverageWiggleFileWriter(PrintStream ps, String trackName) {
        this.ps = ps;
        this.safePrint("track type=wiggle_0 name=" + trackName + "\n");
    }

    private boolean hasPrintStream() {
        return this.ps != null;
    }

    private void safePrint(String s) {
        if (this.hasPrintStream()) {
            this.ps.print(s);
        }
    }

    public void writeCoverage(AlignmentContext context, boolean isBaseCovered) {
        this.writeCoverage(context, isBaseCovered ? 1 : 0);
    }

    public void possiblyGenerateHeader(StringBuilder sb, AlignmentContext context) {
        if (this.lastContigIndex != context.getLocation().getContigIndex() || this.lastPosition + 1L != context.getPosition()) {
            this.lastContigIndex = context.getLocation().getContigIndex();
            sb.append("fixedStep").append(" ").append("chrom=").append(context.getContig()).append(" ").append("start=").append(context.getPosition()).append(" ").append("step=1").append("\n");
        }
        this.lastPosition = context.getPosition();
    }

    public void writeCoverage(AlignmentContext context, int depth) {
        if (this.hasPrintStream()) {
            StringBuilder sb = new StringBuilder();
            this.possiblyGenerateHeader(sb, context);
            sb.append(depth).append("\n");
            this.safePrint(sb.toString());
        }
    }

    public void writeCoverage(AlignmentContext context, double power) {
        if (this.hasPrintStream()) {
            StringBuilder sb = new StringBuilder();
            this.possiblyGenerateHeader(sb, context);
            sb.append(this.fmt.format(power)).append("\n");
            this.safePrint(sb.toString());
        }
    }
}

