/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.cga.tools.gatk.filters;

import net.sf.samtools.SAMRecord;
import org.broadinstitute.sting.commandline.Argument;
import org.broadinstitute.sting.gatk.GenomeAnalysisEngine;
import org.broadinstitute.sting.gatk.filters.ReadFilter;
import org.broadinstitute.sting.utils.GenomeLoc;

public class AmpliconCoordinateFilter
extends ReadFilter {
    @Argument(fullName="amplicon_location", shortName="amploc", doc="amplicon start and stop position", required=true)
    public String ampliconString;
    @Argument(fullName="amplicon_tolerance", shortName="amptol", doc="number of bp tolerance for read to match amplicon start or stop", required=true)
    public int tolerance = 0;
    private GenomeLoc amplicon;

    @Override
    public void initialize(GenomeAnalysisEngine engine) {
        super.initialize(engine);
        this.amplicon = engine.getGenomeLocParser().parseGenomeLoc(this.ampliconString);
    }

    @Override
    public boolean filterOut(SAMRecord rec) {
        int start = rec.getAlignmentStart();
        int end = rec.getAlignmentEnd();
        if (Math.abs(this.amplicon.getStart() - start) > this.tolerance && Math.abs(this.amplicon.getStop() - end) > this.tolerance) {
            return true;
        }
        return !rec.getReferenceName().equals(this.amplicon.getContig());
    }
}

