/*
 * Decompiled with CFR 0.152.
 */
public class Coordinates {
    private double xmultiplier = 70.0;
    private double ymultiplier = 20.0;
    private int xcanvas;
    private int ycanvas;
    private double newickmultiplier;
    private double xstandard;
    private int ymin;
    private int maxdepth;
    private int startx;
    private boolean iscladogram;
    private boolean issimpleclad;

    public Coordinates() {
        this.xcanvas = 500;
        this.ycanvas = 500;
        this.xstandard = 1.0;
        this.ymin = 15;
        this.newickmultiplier = 50.0;
        this.startx = 20;
        this.iscladogram = false;
        this.issimpleclad = false;
    }

    public Coordinates(int n, int n2) {
        this.xcanvas = n;
        this.ycanvas = n2;
        this.xstandard = 1.0;
        this.ymin = 15;
        this.newickmultiplier = 50.0;
        this.startx = 20;
        this.iscladogram = false;
        this.issimpleclad = false;
    }

    public Node findPhylogram(Node node) {
        double d = this.startx;
        double d2 = this.ycanvas / 2;
        this.iscladogram = false;
        this.issimpleclad = false;
        this.findXMultiplier(node);
        this.findYMultiplier(node);
        this.findNewickMultiplier(node);
        this.findCoords(node, d, d2);
        return node;
    }

    public Node findCladogram(Node node) {
        double d = this.startx;
        double d2 = this.ycanvas / 2;
        this.maxdepth = node.getDepth() + 2;
        this.iscladogram = true;
        this.issimpleclad = false;
        this.findXMultiplier(node);
        this.findYMultiplier(node);
        this.findCoords(node, d, d2);
        return node;
    }

    public Node findSimpleClad(Node node) {
        double d = this.startx;
        double d2 = this.ycanvas / 2;
        this.maxdepth = node.getDepth() + 2;
        this.iscladogram = true;
        this.issimpleclad = true;
        this.findXMultiplier(node);
        this.findYMultiplier(node);
        this.findCoords(node, d, d2);
        return node;
    }

    private Node findCoords(Node node, double d, double d2) {
        double d3 = d;
        double d4 = d2;
        double d5 = 0.0;
        double d6 = d2;
        if (node.getType().equals("leaf") && this.iscladogram && !this.issimpleclad) {
            int n = this.maxdepth - node.getLevel();
            d5 = (double)n * this.xmultiplier;
        } else {
            d5 = !this.iscladogram ? node.getLength() * this.newickmultiplier : this.xstandard * this.xmultiplier;
        }
        node.setStartX(d3);
        node.setEndX(d5 += d);
        node.setStandardY(d4);
        d3 = d5;
        if (!node.children.isEmpty()) {
            double d7 = node.getTreeSize();
            d7 /= 2.0;
            d7 = 0.0 - d7;
            double d8 = 0.0;
            double d9 = 0.0;
            double d10 = 0.0;
            double d11 = 0.0;
            int n = node.children.size();
            for (int i = 0; i < n; ++i) {
                double d12 = node.children.get(i).getTreeSize();
                d12 /= 2.0;
                double d13 = 0.0;
                if (i == 0) {
                    d13 = d7 - d12;
                    if (node.children.get(i).getType().equals("internal")) {
                        d13 += d12;
                    }
                } else {
                    d13 = d11;
                }
                d13 += d8;
                if (i > 0) {
                    d13 += 1.0;
                }
                d11 = d13 += d12;
                d8 = d12;
                d13 *= this.ymultiplier;
                if (i == 0) {
                    d9 = d13;
                }
                d10 = d13;
                double d14 = d6 + d13;
                this.findCoords(node.children.get(i), d5, d14);
            }
            d4 = d6 + d9;
            node.setStartY(d4);
            node.setEndY(d6 += d10);
        }
        return node;
    }

    private void findXMultiplier(Node node) {
        int n = node.getDepth();
        int n2 = this.xcanvas;
        n2 -= 20;
        this.xmultiplier = (n2 -= 80) / ++n;
    }

    private void findYMultiplier(Node node) {
        double d = node.getTreeSize();
        int n = this.ycanvas;
        this.ymultiplier = (double)(n -= 40) / d;
        if (this.ymultiplier < (double)this.ymin) {
            this.ymultiplier = this.ymin;
        }
        node.setYmultiplier(this.ymultiplier);
    }

    private void findNewickMultiplier(Node node) {
        double d = node.getNewickLength();
        int n = this.xcanvas;
        n -= 20;
        this.newickmultiplier = (double)(n -= 80) / d;
    }
}

