"""
CuffData 
"""
import logging
import os,os.path,re
import galaxy.datatypes.data
from galaxy.datatypes.images import Html
from galaxy.datatypes.binary import Binary
from galaxy import util
from galaxy.datatypes.metadata import MetadataElement

log = logging.getLogger(__name__)

class CuffDiffData( Html ):
    """
    CuffDiff output files:
    run.info
    read_groups.info
    cds.count_tracking
    cds.diff
    cds.fpkm_tracking
    cds.read_group_tracking
    cds_exp.diff
    gene_exp.diff
    genes.count_tracking
    genes.fpkm_tracking
    genes.read_group_tracking
    isoform_exp.diff
    isoforms.count_tracking
    isoforms.fpkm_tracking
    isoforms.read_group_tracking
    promoters.diff
    splicing.diff
    tss_group_exp.diff
    tss_groups.count_tracking
    tss_groups.fpkm_tracking
    tss_groups.read_group_tracking
    """
    file_ext = 'cuffdata'
    is_binary = False
    composite_type = 'auto_primary_file'
    allow_datatype_change = False

    def generate_primary_file( self, dataset = None ):
        """ 
        This is called only at upload to write the html file
        cannot rename the datasets here - they come with the default unfortunately
        """
        return '<html><head></head><body>AutoGenerated Primary File for Composite Dataset</body></html>'

    def regenerate_primary_file(self,dataset):
        """
        cannot do this until we are setting metadata 
        """
        flist = os.listdir(dataset.extra_files_path)
        rval = ['<html><head><title>CuffDiff Output</title></head>']
        rval.append('<body>')
        rval.append('<p/>CuffDiff Outputs:<p/><ul>')
        for i,fname in enumerate(flist):
            sfname = os.path.split(fname)[-1]
            rval.append( '<li><a href="%s" type="text/html">%s</a>' % ( sfname, sfname ) )
        rval.append( '</ul></body></html>' )
        f = file(dataset.file_name,'w')
        f.write("\n".join( rval ))
        f.write('\n')
        f.close()

    def set_meta( self, dataset, **kwd ):
        Html.set_meta( self, dataset, **kwd )
        self.regenerate_primary_file(dataset)

    def sniff( self, filename ):
        return False

class CuffDataDB( Binary ):
    file_ext = 'cuffdata'
    is_binary = True
    allow_datatype_change = False
