/*
 * Decompiled with CFR 0.152.
 */
package picard.sam.markduplicates.util;

import htsjdk.samtools.util.SortingCollection;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import picard.PicardException;
import picard.sam.markduplicates.util.ReadEndsForMarkDuplicates;

public class ReadEndsForMarkDuplicatesCodec
implements SortingCollection.Codec<ReadEndsForMarkDuplicates> {
    protected DataInputStream in;
    protected DataOutputStream out;

    @Override
    public SortingCollection.Codec<ReadEndsForMarkDuplicates> clone() {
        return new ReadEndsForMarkDuplicatesCodec();
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.out = new DataOutputStream(os);
    }

    @Override
    public void setInputStream(InputStream is) {
        this.in = new DataInputStream(is);
    }

    public DataInputStream getInputStream() {
        return this.in;
    }

    public DataOutputStream getOutputStream() {
        return this.out;
    }

    @Override
    public void encode(ReadEndsForMarkDuplicates read) {
        try {
            this.out.writeShort(read.score);
            this.out.writeShort(read.libraryId);
            this.out.writeByte(read.orientation);
            this.out.writeInt(read.read1ReferenceIndex);
            this.out.writeInt(read.read1Coordinate);
            this.out.writeLong(read.read1IndexInFile);
            this.out.writeInt(read.read2ReferenceIndex);
            if (read.orientation > 1) {
                this.out.writeInt(read.read2Coordinate);
                this.out.writeLong(read.read2IndexInFile);
            }
            this.out.writeShort(read.readGroup);
            this.out.writeShort(read.tile);
            this.out.writeShort(read.x);
            this.out.writeShort(read.y);
            this.out.writeByte(read.orientationForOpticalDuplicates);
        }
        catch (IOException ioe) {
            throw new PicardException("Exception writing ReadEnds to file.", ioe);
        }
    }

    @Override
    public ReadEndsForMarkDuplicates decode() {
        ReadEndsForMarkDuplicates read = new ReadEndsForMarkDuplicates();
        try {
            try {
                read.score = this.in.readShort();
            }
            catch (EOFException eof) {
                return null;
            }
            read.libraryId = this.in.readShort();
            read.orientation = this.in.readByte();
            read.read1ReferenceIndex = this.in.readInt();
            read.read1Coordinate = this.in.readInt();
            read.read1IndexInFile = this.in.readLong();
            read.read2ReferenceIndex = this.in.readInt();
            if (read.orientation > 1) {
                read.read2Coordinate = this.in.readInt();
                read.read2IndexInFile = this.in.readLong();
            }
            read.readGroup = this.in.readShort();
            read.tile = this.in.readShort();
            read.x = this.in.readShort();
            read.y = this.in.readShort();
            read.orientationForOpticalDuplicates = this.in.readByte();
            return read;
        }
        catch (IOException ioe) {
            throw new PicardException("Exception writing ReadEnds to file.", ioe);
        }
    }
}

