from pathlib import Path

from checkm.taxonParser import TaxonParser
from checkm.util.taxonomyUtils import taxonomicRanks

if __name__ == '__main__':
    tool_data_dp = Path('tool-data')

    # get all available marker sets
    taxonParser = TaxonParser()
    taxonMarkerSets = taxonParser.readMarkerSets()

    # create a table per rank
    for rank in taxonomicRanks:
        rank_fp = tool_data_dp / Path("%s.loc.sample" % rank)
        with rank_fp.open('w') as rank_f:
            rank_f.write('# File generated by format_taxon_list.py script\n')
            rank_f.write('# taxon\tdescription\n')
            for taxon in sorted(taxonMarkerSets[rank]):
                markerSet = taxonMarkerSets[rank][taxon]
                numMarkers, numMarkerSets = markerSet.size()
                rank_f.write('{taxon}\t{taxon} ({markerSet.numGenomes} genomes, {numMarkers} marker genes, {numMarkerSets} marker sets)\n')
