/*
 * Decompiled with CFR 0.152.
 */
package PileupScripts;

import PileupObjects.BEDCoord;
import PileupObjects.PileupParameters;
import PileupScripts.TransformArray;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.util.Vector;

public class PileupExtract
implements Runnable {
    PileupParameters param;
    File BAM;
    Vector<BEDCoord> INPUT;
    int index;
    int subsetsize;
    SamReader inputSam;

    @Override
    public void run() {
        this.inputSam = SamReaderFactory.makeDefault().open(this.BAM);
        int x = this.index;
        while (x < this.index + this.subsetsize) {
            if (this.INPUT.get(x).getStatus()) {
                this.extract(this.INPUT.get(x));
            }
            ++x;
        }
    }

    public PileupExtract(PileupParameters p, File b, Vector<BEDCoord> i, int current, int length) {
        this.param = p;
        this.BAM = b;
        this.INPUT = i;
        this.index = current;
        this.subsetsize = length;
    }

    public void extract(BEDCoord read) {
        double[] TAG_S1 = null;
        double[] TAG_S2 = null;
        int SHIFT = this.param.getShift();
        int STRAND = this.param.getStrand();
        int BEDSTART = read.getStart();
        int BEDSTOP = read.getStop();
        if (read.getDir().equals("-")) {
            ++BEDSTART;
            ++BEDSTOP;
        }
        int WINDOW = BEDSTOP - BEDSTART + this.param.getBin() / 2 * 2;
        int QUERYWINDOW = 0;
        if (this.param.getTrans() == 1) {
            WINDOW = BEDSTOP - BEDSTART + this.param.getBin() * this.param.getSmooth() * 2;
            QUERYWINDOW = this.param.getBin() * this.param.getSmooth();
        } else if (this.param.getTrans() == 2) {
            WINDOW = BEDSTOP - BEDSTART + this.param.getBin() * this.param.getStdSize() * this.param.getStdNum() * 2;
            QUERYWINDOW = this.param.getBin() * this.param.getStdSize() * this.param.getStdNum();
        }
        TAG_S1 = new double[WINDOW];
        if (STRAND == 0) {
            TAG_S2 = new double[WINDOW];
        }
        SAMRecordIterator iter = this.inputSam.query(read.getChrom(), BEDSTART - QUERYWINDOW - SHIFT - 1, BEDSTOP + QUERYWINDOW + SHIFT + 1, false);
        while (iter.hasNext()) {
            int FivePrime;
            SAMRecord sr = (SAMRecord)iter.next();
            if (sr.getReadPairedFlag()) {
                if ((!sr.getProperPairFlag() || !this.param.getPErequire()) && this.param.getPErequire() || !(sr.getFirstOfPairFlag() && this.param.getRead() == 0 || !sr.getFirstOfPairFlag() && this.param.getRead() == 1) && this.param.getRead() != 2) continue;
                FivePrime = sr.getUnclippedStart() - 1;
                if (sr.getReadNegativeStrandFlag()) {
                    FivePrime = sr.getUnclippedEnd();
                    FivePrime -= SHIFT;
                } else {
                    FivePrime += SHIFT;
                }
                if ((FivePrime -= BEDSTART - QUERYWINDOW) < 0 || FivePrime >= TAG_S1.length) continue;
                if (STRAND == 0) {
                    if (!sr.getReadNegativeStrandFlag() && read.getDir().equals("-")) {
                        int n = FivePrime;
                        TAG_S2[n] = TAG_S2[n] + 1.0;
                        continue;
                    }
                    if (sr.getReadNegativeStrandFlag() && read.getDir().equals("+")) {
                        int n = FivePrime;
                        TAG_S2[n] = TAG_S2[n] + 1.0;
                        continue;
                    }
                    if (!sr.getReadNegativeStrandFlag() && read.getDir().equals("+")) {
                        int n = FivePrime;
                        TAG_S1[n] = TAG_S1[n] + 1.0;
                        continue;
                    }
                    if (!sr.getReadNegativeStrandFlag() || !read.getDir().equals("-")) continue;
                    int n = FivePrime;
                    TAG_S1[n] = TAG_S1[n] + 1.0;
                    continue;
                }
                int n = FivePrime;
                TAG_S1[n] = TAG_S1[n] + 1.0;
                continue;
            }
            if (this.param.getRead() != 0 && this.param.getRead() != 2) continue;
            FivePrime = sr.getUnclippedStart() - 1;
            if (sr.getReadNegativeStrandFlag()) {
                FivePrime = sr.getUnclippedEnd();
                FivePrime -= SHIFT;
            } else {
                FivePrime += SHIFT;
            }
            if ((FivePrime -= BEDSTART - QUERYWINDOW) < 0 || FivePrime >= TAG_S1.length) continue;
            if (STRAND == 0) {
                if (!sr.getReadNegativeStrandFlag() && read.getDir().equals("-")) {
                    int n = FivePrime;
                    TAG_S2[n] = TAG_S2[n] + 1.0;
                    continue;
                }
                if (sr.getReadNegativeStrandFlag() && read.getDir().equals("+")) {
                    int n = FivePrime;
                    TAG_S2[n] = TAG_S2[n] + 1.0;
                    continue;
                }
                if (!sr.getReadNegativeStrandFlag() && read.getDir().equals("+")) {
                    int n = FivePrime;
                    TAG_S1[n] = TAG_S1[n] + 1.0;
                    continue;
                }
                if (!sr.getReadNegativeStrandFlag() || !read.getDir().equals("-")) continue;
                int n = FivePrime;
                TAG_S1[n] = TAG_S1[n] + 1.0;
                continue;
            }
            int n = FivePrime;
            TAG_S1[n] = TAG_S1[n] + 1.0;
        }
        iter.close();
        if (read.getDir().equals("-")) {
            TAG_S1 = TransformArray.reverseTran(TAG_S1);
            TAG_S2 = TransformArray.reverseTran(TAG_S2);
        }
        double[] binF = new double[TAG_S1.length];
        double[] binR = null;
        if (TAG_S2 != null) {
            binR = new double[TAG_S2.length];
        }
        int j = 0;
        while (j < TAG_S1.length) {
            int k = j - this.param.getBin() / 2;
            while (k <= j + this.param.getBin() / 2) {
                if (k < 0) {
                    k = 0;
                }
                if (k >= TAG_S1.length) {
                    k = j + this.param.getBin() / 2 + 1;
                } else {
                    int n = k;
                    binF[n] = binF[n] + TAG_S1[j];
                    if (binR != null) {
                        int n2 = k;
                        binR[n2] = binR[n2] + TAG_S2[j];
                    }
                }
                ++k;
            }
            ++j;
        }
        double[] finalF = new double[TAG_S1.length / this.param.getBin()];
        double[] finalR = null;
        if (TAG_S2 != null) {
            finalR = new double[TAG_S2.length / this.param.getBin()];
        }
        int x = this.param.getBin() / 2;
        while (x < TAG_S1.length - this.param.getBin() / 2) {
            finalF[(x - this.param.getBin() / 2) / this.param.getBin()] = TAG_S1[x];
            if (TAG_S2 != null) {
                finalR[(x - this.param.getBin() / 2) / this.param.getBin()] = TAG_S2[x];
            }
            x += this.param.getBin();
        }
        if (this.param.getStandard()) {
            int i = 0;
            while (i < finalF.length) {
                if (finalF != null) {
                    int n = i;
                    finalF[n] = finalF[n] / this.param.getRatio();
                }
                if (finalR != null) {
                    int n = i;
                    finalR[n] = finalR[n] / this.param.getRatio();
                }
                ++i;
            }
        }
        read.setFstrand(finalF);
        read.setRstrand(finalR);
    }
}

