/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.Log;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import picard.util.AtomicIterator;
import picard.util.Iterators;
import picard.vcf.processor.VariantIteratorProducer;
import picard.vcf.processor.VariantProcessor;

public interface VariantAccumulatorExecutor<ACCUMULATOR extends VariantProcessor.Accumulator<RESULT>, RESULT> {
    public void start();

    public void awaitCompletion() throws InterruptedException;

    public Collection<ACCUMULATOR> accumulators();

    public static class MultiThreadedChunkBased<A extends VariantProcessor.Accumulator<R>, R>
    implements VariantAccumulatorExecutor<A, R> {
        private static final Log LOG = Log.getInstance(MultiThreadedChunkBased.class);
        final AtomicIterator<CloseableIterator<VariantContext>> vcIterators;
        final ExecutorService executor;
        final Collection<A> accumulators = Collections.synchronizedCollection(new ArrayList());
        volatile boolean started = false;
        final int numThreads;
        private final List<Throwable> childrenErrors = Collections.synchronizedList(new ArrayList());
        final VariantProcessor.AccumulatorGenerator<A, R> accumulatorGenerator;

        public MultiThreadedChunkBased(int numThreads, VariantIteratorProducer vcIteratorProducer, VariantProcessor.AccumulatorGenerator<A, R> accumulatorGenerator) {
            this.executor = Executors.newFixedThreadPool(numThreads);
            this.vcIterators = Iterators.atomicIteratorOf(vcIteratorProducer.iterators());
            this.numThreads = numThreads;
            this.accumulatorGenerator = accumulatorGenerator;
        }

        @Override
        public synchronized void start() {
            this.started = true;
            for (int i = 0; i < this.numThreads; ++i) {
                A accumulator = this.accumulatorGenerator.build();
                this.accumulators.add(accumulator);
                this.executor.submit(new Worker((VariantProcessor.Accumulator)accumulator));
            }
            this.executor.shutdown();
        }

        @Override
        public synchronized Collection<A> accumulators() {
            return Collections.unmodifiableCollection(this.accumulators);
        }

        @Override
        public void awaitCompletion() throws InterruptedException {
            if (!this.started) {
                throw new IllegalStateException("This method can be called only after the executor has been started.");
            }
            this.executor.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
            if (!this.childrenErrors.isEmpty()) {
                throw new MultiException(this.childrenErrors);
            }
        }

        class Worker
        implements Runnable {
            final VariantProcessor.Accumulator processor;

            Worker(VariantProcessor.Accumulator processor) {
                this.processor = processor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    Optional<CloseableIterator<VariantContext>> readerMaybe;
                    while ((readerMaybe = MultiThreadedChunkBased.this.vcIterators.next()).isPresent()) {
                        CloseableIterator<VariantContext> reader = readerMaybe.get();
                        while (reader.hasNext()) {
                            this.processor.accumulate((VariantContext)reader.next());
                        }
                        reader.close();
                        if (MultiThreadedChunkBased.this.childrenErrors.isEmpty()) continue;
                        LOG.error(Thread.currentThread() + " aborting: observed error in another child thread.");
                        break;
                    }
                }
                catch (Throwable e) {
                    try {
                        MultiThreadedChunkBased.this.childrenErrors.add(e);
                        LOG.error(e, "Unexpected exception encountered in child thread.");
                    }
                    catch (Throwable throwable) {
                        LOG.debug(String.format("Thread %s is finishing.", Thread.currentThread()));
                        throw throwable;
                    }
                    LOG.debug(String.format("Thread %s is finishing.", Thread.currentThread()));
                }
                LOG.debug(String.format("Thread %s is finishing.", Thread.currentThread()));
            }
        }

        static class MultiException
        extends RuntimeException {
            final List<Throwable> childrenExceptions;

            public MultiException(List<Throwable> childrenExceptions) {
                this.childrenExceptions = childrenExceptions;
            }

            @Override
            public String getMessage() {
                return "Children threads encountered exceptions:\n" + Joiner.on("\n\t").join(FluentIterable.from(this.childrenExceptions).transform(new Function<Throwable, String>(){

                    @Override
                    public String apply(Throwable throwable) {
                        return throwable.getMessage();
                    }
                }));
            }
        }
    }
}

