/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import picard.vcf.GenotypeConcordanceStateCodes;

public class GenotypeConcordanceStates {

    static class TruthAndCallStates
    implements Comparable<TruthAndCallStates> {
        public final TruthState truthState;
        public final CallState callState;

        public TruthAndCallStates(TruthState truthState, CallState callState) {
            this.truthState = truthState;
            this.callState = callState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compareTo((TruthAndCallStates)o) == 0;
        }

        public int hashCode() {
            int result = this.truthState.hashCode();
            result = 31 * result + this.callState.hashCode();
            return result;
        }

        @Override
        public int compareTo(TruthAndCallStates that) {
            int result = this.truthState.compareTo(that.truthState);
            if (result == 0) {
                result = this.callState.compareTo(that.callState);
            }
            return result;
        }
    }

    static enum ContingencyState {
        TP,
        FP,
        TN,
        FN,
        NA,
        EMPTY;

    }

    static final class CallState
    extends Enum<CallState> {
        public static final /* enum */ CallState MISSING = new CallState(GenotypeConcordanceStateCodes.MISSING_CODE.ordinal());
        public static final /* enum */ CallState HOM_REF = new CallState(GenotypeConcordanceStateCodes.HOM_REF_CODE.ordinal());
        public static final /* enum */ CallState HET_REF_VAR1 = new CallState(GenotypeConcordanceStateCodes.HET_REF_VAR1_CODE.ordinal());
        public static final /* enum */ CallState HET_VAR1_VAR2 = new CallState(GenotypeConcordanceStateCodes.HET_VAR1_VAR2_CODE.ordinal());
        public static final /* enum */ CallState HOM_VAR1 = new CallState(GenotypeConcordanceStateCodes.HOM_VAR1_CODE.ordinal());
        public static final /* enum */ CallState HET_REF_VAR2 = new CallState(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal());
        public static final /* enum */ CallState HET_REF_VAR3 = new CallState(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal());
        public static final /* enum */ CallState HET_VAR1_VAR3 = new CallState(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal());
        public static final /* enum */ CallState HET_VAR3_VAR4 = new CallState(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal());
        public static final /* enum */ CallState HOM_VAR2 = new CallState(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal());
        public static final /* enum */ CallState HOM_VAR3 = new CallState(GenotypeConcordanceStateCodes.INCOMPARABLE_CODE.ordinal());
        public static final /* enum */ CallState NO_CALL = new CallState(GenotypeConcordanceStateCodes.NO_CALL_CODE.ordinal());
        public static final /* enum */ CallState LOW_GQ = new CallState(GenotypeConcordanceStateCodes.LOW_GQ_CODE.ordinal());
        public static final /* enum */ CallState LOW_DP = new CallState(GenotypeConcordanceStateCodes.LOW_DP_CODE.ordinal());
        public static final /* enum */ CallState VC_FILTERED = new CallState(GenotypeConcordanceStateCodes.VC_FILTERED_CODE.ordinal());
        public static final /* enum */ CallState GT_FILTERED = new CallState(GenotypeConcordanceStateCodes.GT_FILTERED_CODE.ordinal());
        public static final /* enum */ CallState IS_MIXED = new CallState(GenotypeConcordanceStateCodes.IS_MIXED_CODE.ordinal());
        private final int code;
        private static final /* synthetic */ CallState[] $VALUES;

        public static CallState[] values() {
            return (CallState[])$VALUES.clone();
        }

        public static CallState valueOf(String name) {
            return Enum.valueOf(CallState.class, name);
        }

        public static CallState getHom(int alleleIdx) {
            if (alleleIdx == 0) {
                return HOM_REF;
            }
            if (alleleIdx == 1) {
                return HOM_VAR1;
            }
            if (alleleIdx == 2) {
                return HOM_VAR2;
            }
            if (alleleIdx == 3) {
                return HOM_VAR3;
            }
            assert (false);
            return null;
        }

        public static CallState getHet(int allele0idx, int allele1idx) {
            if (allele0idx > allele1idx) {
                int temp = allele0idx;
                allele0idx = allele1idx;
                allele1idx = temp;
            }
            if (allele0idx == 0) {
                if (allele1idx == 1) {
                    return HET_REF_VAR1;
                }
                if (allele1idx == 2) {
                    return HET_REF_VAR2;
                }
                if (allele1idx == 3) {
                    return HET_REF_VAR3;
                }
                assert (false);
                return null;
            }
            if (allele0idx == 1) {
                if (allele1idx == 2) {
                    return HET_VAR1_VAR2;
                }
                if (allele1idx == 3) {
                    return HET_VAR1_VAR3;
                }
                assert (false);
                return null;
            }
            if (allele0idx == 2 && allele1idx == 3) {
                return HET_VAR3_VAR4;
            }
            if (allele0idx == 3 && allele1idx == 4) {
                return HET_VAR3_VAR4;
            }
            assert (false);
            return null;
        }

        private CallState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static {
            $VALUES = new CallState[]{MISSING, HOM_REF, HET_REF_VAR1, HET_VAR1_VAR2, HOM_VAR1, HET_REF_VAR2, HET_REF_VAR3, HET_VAR1_VAR3, HET_VAR3_VAR4, HOM_VAR2, HOM_VAR3, NO_CALL, LOW_GQ, LOW_DP, VC_FILTERED, GT_FILTERED, IS_MIXED};
        }
    }

    public static final class TruthState
    extends Enum<TruthState> {
        public static final /* enum */ TruthState MISSING = new TruthState(GenotypeConcordanceStateCodes.MISSING_CODE.ordinal());
        public static final /* enum */ TruthState HOM_REF = new TruthState(GenotypeConcordanceStateCodes.HOM_REF_CODE.ordinal());
        public static final /* enum */ TruthState HET_REF_VAR1 = new TruthState(GenotypeConcordanceStateCodes.HET_REF_VAR1_CODE.ordinal());
        public static final /* enum */ TruthState HET_VAR1_VAR2 = new TruthState(GenotypeConcordanceStateCodes.HET_VAR1_VAR2_CODE.ordinal());
        public static final /* enum */ TruthState HOM_VAR1 = new TruthState(GenotypeConcordanceStateCodes.HOM_VAR1_CODE.ordinal());
        public static final /* enum */ TruthState NO_CALL = new TruthState(GenotypeConcordanceStateCodes.NO_CALL_CODE.ordinal());
        public static final /* enum */ TruthState LOW_GQ = new TruthState(GenotypeConcordanceStateCodes.LOW_GQ_CODE.ordinal());
        public static final /* enum */ TruthState LOW_DP = new TruthState(GenotypeConcordanceStateCodes.LOW_DP_CODE.ordinal());
        public static final /* enum */ TruthState VC_FILTERED = new TruthState(GenotypeConcordanceStateCodes.VC_FILTERED_CODE.ordinal());
        public static final /* enum */ TruthState GT_FILTERED = new TruthState(GenotypeConcordanceStateCodes.GT_FILTERED_CODE.ordinal());
        public static final /* enum */ TruthState IS_MIXED = new TruthState(GenotypeConcordanceStateCodes.IS_MIXED_CODE.ordinal());
        private final int code;
        private static final /* synthetic */ TruthState[] $VALUES;

        public static TruthState[] values() {
            return (TruthState[])$VALUES.clone();
        }

        public static TruthState valueOf(String name) {
            return Enum.valueOf(TruthState.class, name);
        }

        public static TruthState getHom(int alleleIdx) {
            if (alleleIdx == 0) {
                return HOM_REF;
            }
            if (alleleIdx == 1) {
                return HOM_VAR1;
            }
            assert (false);
            return null;
        }

        public static TruthState getVar(int allele0idx, int allele1idx) {
            if (allele0idx == 0 && allele1idx == 1) {
                return HET_REF_VAR1;
            }
            if (allele0idx == 1 && allele1idx == 0) {
                return HET_REF_VAR1;
            }
            if (allele0idx == 1 && allele1idx == 2) {
                return HET_VAR1_VAR2;
            }
            if (allele0idx == 2 && allele1idx == 1) {
                return HET_VAR1_VAR2;
            }
            assert (false);
            return null;
        }

        private TruthState(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        static {
            $VALUES = new TruthState[]{MISSING, HOM_REF, HET_REF_VAR1, HET_VAR1_VAR2, HOM_VAR1, NO_CALL, LOW_GQ, LOW_DP, VC_FILTERED, GT_FILTERED, IS_MIXED};
        }
    }
}

