/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.util.ListMap;
import htsjdk.samtools.util.SequenceUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.analysis.artifacts.SequencingArtifactMetrics;
import picard.analysis.artifacts.Transition;

class ContextAccumulator {
    private final boolean expectedTandemReads;
    private final Map<Transition, Map<String, AlignmentAccumulator>> artifactMap;

    public ContextAccumulator(Set<String> contexts, boolean expectedTandemReads) {
        this.expectedTandemReads = expectedTandemReads;
        this.artifactMap = new HashMap<Transition, Map<String, AlignmentAccumulator>>();
        for (Transition transition : Transition.values()) {
            this.artifactMap.put(transition, new HashMap());
        }
        for (String context : contexts) {
            char refBase = this.getCentralBase(context);
            for (byte calledBase : SequenceUtil.VALID_BASES_UPPER) {
                Transition transition = Transition.transitionOf(refBase, (char)calledBase);
                this.artifactMap.get((Object)transition).put(context, new AlignmentAccumulator());
            }
        }
    }

    public void countRecord(String refContext, char calledBase, SAMRecord rec) {
        char refBase = this.getCentralBase(refContext);
        Transition transition = Transition.transitionOf(refBase, calledBase);
        this.artifactMap.get((Object)transition).get(refContext).countRecord(rec);
    }

    public ListMap<Transition, SequencingArtifactMetrics.DetailPair> calculateMetrics(String sampleAlias, String library) {
        ListMap<Transition, SequencingArtifactMetrics.DetailPair> detailMetricsMap = new ListMap<Transition, SequencingArtifactMetrics.DetailPair>();
        for (Transition altTransition : Transition.altValues()) {
            Transition refTransition = altTransition.matchingRef();
            for (String context : this.artifactMap.get((Object)altTransition).keySet()) {
                SequencingArtifactMetrics.PreAdapterDetailMetrics preAdapterDetailMetrics = new SequencingArtifactMetrics.PreAdapterDetailMetrics();
                SequencingArtifactMetrics.BaitBiasDetailMetrics baitBiasDetailMetrics = new SequencingArtifactMetrics.BaitBiasDetailMetrics();
                preAdapterDetailMetrics.SAMPLE_ALIAS = sampleAlias;
                preAdapterDetailMetrics.LIBRARY = library;
                preAdapterDetailMetrics.CONTEXT = context;
                preAdapterDetailMetrics.REF_BASE = altTransition.ref();
                preAdapterDetailMetrics.ALT_BASE = altTransition.call();
                baitBiasDetailMetrics.SAMPLE_ALIAS = sampleAlias;
                baitBiasDetailMetrics.LIBRARY = library;
                baitBiasDetailMetrics.CONTEXT = context;
                baitBiasDetailMetrics.REF_BASE = altTransition.ref();
                baitBiasDetailMetrics.ALT_BASE = altTransition.call();
                AlignmentAccumulator fwdRefAlignments = this.artifactMap.get((Object)refTransition).get(context);
                AlignmentAccumulator fwdAltAlignments = this.artifactMap.get((Object)altTransition).get(context);
                AlignmentAccumulator revRefAlignments = this.artifactMap.get((Object)refTransition.complement()).get(SequenceUtil.reverseComplement(context));
                AlignmentAccumulator revAltAlignments = this.artifactMap.get((Object)altTransition.complement()).get(SequenceUtil.reverseComplement(context));
                if (this.expectedTandemReads) {
                    preAdapterDetailMetrics.PRO_REF_BASES = fwdRefAlignments.R1_POS + fwdRefAlignments.R2_POS + revRefAlignments.R1_NEG + revRefAlignments.R2_NEG;
                    preAdapterDetailMetrics.PRO_ALT_BASES = fwdAltAlignments.R1_POS + fwdAltAlignments.R2_POS + revAltAlignments.R1_NEG + revAltAlignments.R2_NEG;
                    preAdapterDetailMetrics.CON_REF_BASES = fwdRefAlignments.R1_NEG + fwdRefAlignments.R2_NEG + revRefAlignments.R1_POS + revRefAlignments.R2_POS;
                    preAdapterDetailMetrics.CON_ALT_BASES = fwdAltAlignments.R1_NEG + fwdAltAlignments.R2_NEG + revAltAlignments.R1_POS + revAltAlignments.R2_POS;
                } else {
                    preAdapterDetailMetrics.PRO_REF_BASES = fwdRefAlignments.R1_POS + fwdRefAlignments.R2_NEG + revRefAlignments.R1_NEG + revRefAlignments.R2_POS;
                    preAdapterDetailMetrics.PRO_ALT_BASES = fwdAltAlignments.R1_POS + fwdAltAlignments.R2_NEG + revAltAlignments.R1_NEG + revAltAlignments.R2_POS;
                    preAdapterDetailMetrics.CON_REF_BASES = fwdRefAlignments.R1_NEG + fwdRefAlignments.R2_POS + revRefAlignments.R1_POS + revRefAlignments.R2_NEG;
                    preAdapterDetailMetrics.CON_ALT_BASES = fwdAltAlignments.R1_NEG + fwdAltAlignments.R2_POS + revAltAlignments.R1_POS + revAltAlignments.R2_NEG;
                }
                baitBiasDetailMetrics.FWD_CXT_REF_BASES = fwdRefAlignments.R1_POS + fwdRefAlignments.R1_NEG + fwdRefAlignments.R2_POS + fwdRefAlignments.R2_NEG;
                baitBiasDetailMetrics.FWD_CXT_ALT_BASES = fwdAltAlignments.R1_POS + fwdAltAlignments.R1_NEG + fwdAltAlignments.R2_POS + fwdAltAlignments.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_REF_BASES = revRefAlignments.R1_POS + revRefAlignments.R1_NEG + revRefAlignments.R2_POS + revRefAlignments.R2_NEG;
                baitBiasDetailMetrics.REV_CXT_ALT_BASES = revAltAlignments.R1_POS + revAltAlignments.R1_NEG + revAltAlignments.R2_POS + revAltAlignments.R2_NEG;
                preAdapterDetailMetrics.calculateDerivedStatistics();
                baitBiasDetailMetrics.calculateDerivedStatistics();
                detailMetricsMap.add(altTransition, new SequencingArtifactMetrics.DetailPair(preAdapterDetailMetrics, baitBiasDetailMetrics));
            }
        }
        return detailMetricsMap;
    }

    private char getCentralBase(String context) {
        if (context.length() % 2 == 0) {
            throw new PicardException("Contexts cannot have an even number of bases: " + context);
        }
        return context.charAt(context.length() / 2);
    }

    private static class AlignmentAccumulator {
        private long R1_POS = 0L;
        private long R1_NEG = 0L;
        private long R2_POS = 0L;
        private long R2_NEG = 0L;

        private AlignmentAccumulator() {
        }

        private void countRecord(SAMRecord rec) {
            boolean isReadTwo;
            boolean isNegativeStrand = rec.getReadNegativeStrandFlag();
            boolean bl = isReadTwo = rec.getReadPairedFlag() && rec.getSecondOfPairFlag();
            if (isReadTwo) {
                if (isNegativeStrand) {
                    ++this.R2_NEG;
                } else {
                    ++this.R2_POS;
                }
            } else if (isNegativeStrand) {
                ++this.R1_NEG;
            } else {
                ++this.R1_POS;
            }
        }
    }
}

