/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import org.xerial.snappy.SnappyErrorCode;

public class SnappyException
extends Exception {
    private static final long serialVersionUID = 1L;
    public final SnappyErrorCode errorCode;

    public SnappyException(int code) {
        SnappyErrorCode[] values = SnappyErrorCode.values();
        this.errorCode = code < 0 || code >= values.length ? SnappyErrorCode.UNKNOWN : values[code];
    }

    public SnappyException(SnappyErrorCode errorCode) {
        this.errorCode = errorCode;
    }

    public SnappyException(SnappyErrorCode errorCode, Exception e) {
        super(e);
        this.errorCode = errorCode;
    }

    public SnappyException(SnappyErrorCode errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
    }

    public SnappyErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return String.format("[%s] %s", this.errorCode.name(), super.getMessage());
    }
}

