/*
 * Decompiled with CFR 0.152.
 */
import PileupObjects.BEDCoord;
import PileupObjects.PileupParameters;
import PileupScripts.BAMUtilities;
import PileupScripts.PileupExtract;
import PileupScripts.TransformArray;
import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Scanner;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class TagPileup {
    private static boolean TAGSEQUAL = false;
    private static int SHIFT = 0;
    private static int BINSIZE = 1;
    private static int SMOOTHWINDOW = 0;
    private static int STRAND = 0;
    private static int READ = 0;
    private static boolean PE_STATUS = false;
    private static int CPU = 1;
    private static boolean OUTPUT_HEATMAP = true;
    private static boolean OUTPUT_COMP = true;
    private static File BAM = null;
    private static File BAI = null;
    private static File BED = null;
    private static Vector<BEDCoord> INPUT = null;
    private static String HPATH = null;
    private static String CNAME = null;
    private static PileupParameters PARAM = null;
    private static PrintStream COMPOSITE = null;
    private static PrintStream OUT_S1 = null;
    private static PrintStream OUT_S2 = null;

    public static void main(String[] args) throws IOException {
        TagPileup.loadConfig(args);
        System.out.println("\n" + TagPileup.getTimeStamp() + "\nLoading BED Coordinates..");
        INPUT = TagPileup.loadCoord(BED);
        System.out.println("BED Coordinates Loaded\n" + TagPileup.getTimeStamp());
        TagPileup.validateBED();
        System.out.println("\n" + TagPileup.getTimeStamp() + "\nParsing Tags...");
        TagPileup.run();
        System.out.println("Tags Parsed\n" + TagPileup.getTimeStamp());
    }

    public static int getMaxBEDSize(Vector<BEDCoord> sites) {
        int maxSize = 0;
        int x = 0;
        while (x < sites.size()) {
            int SIZE = sites.get(x).getFStrand().length;
            if (SIZE > maxSize) {
                maxSize = SIZE;
            }
            ++x;
        }
        return maxSize;
    }

    public static void validateBED() throws IOException {
        SamReader inputSam = SamReaderFactory.makeDefault().open(BAM);
        AbstractBAMFileIndex bai = (AbstractBAMFileIndex)inputSam.indexing().getIndex();
        ArrayList<String> chrom = new ArrayList<String>();
        int x = 0;
        while (x < bai.getNumberOfReferences()) {
            chrom.add(inputSam.getFileHeader().getSequence(x).getSequenceName());
            ++x;
        }
        inputSam.close();
        bai.close();
        ArrayList<Integer> indexFail = new ArrayList<Integer>();
        int FAILcount = 0;
        int x2 = 0;
        while (x2 < INPUT.size()) {
            if (!chrom.contains(INPUT.get(x2).getChrom())) {
                INPUT.get(x2).setStatus(false);
                indexFail.add(new Integer(x2));
                ++FAILcount;
            }
            if (INPUT.get(x2).getStart() > INPUT.get(x2).getStop()) {
                INPUT.get(x2).setStatus(false);
                indexFail.add(new Integer(x2));
                ++FAILcount;
            }
            ++x2;
        }
        if (FAILcount == INPUT.size()) {
            System.err.println("No BED Coordinates exist within BAM file!!!");
            TagPileup.printUsage();
            System.exit(1);
        }
        x2 = indexFail.size() - 1;
        while (x2 >= 0) {
            INPUT.remove((Integer)indexFail.get(x2));
            --x2;
        }
    }

    public static void run() throws IOException {
        int i;
        block59: {
            if (PARAM.getOutputCompositeStatus()) {
                try {
                    COMPOSITE = CNAME != null ? new PrintStream(CNAME) : new PrintStream("composite.out");
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
            if (PARAM.getStandard()) {
                PARAM.setRatio(BAMUtilities.calculateStandardizationRatio(BAM));
            }
            if (PARAM.getOutputType() != 0) {
                if (STRAND == 0) {
                    try {
                        if (HPATH != null) {
                            OUT_S1 = new PrintStream(String.valueOf(HPATH) + File.separator + TagPileup.generateFileName(BED.getName(), BAM.getName(), 0));
                            OUT_S2 = new PrintStream(String.valueOf(HPATH) + File.separator + TagPileup.generateFileName(BED.getName(), BAM.getName(), 1));
                            break block59;
                        }
                        OUT_S1 = new PrintStream(TagPileup.generateFileName(BED.getName(), BAM.getName(), 0));
                        OUT_S2 = new PrintStream(TagPileup.generateFileName(BED.getName(), BAM.getName(), 1));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        OUT_S1 = HPATH != null ? new PrintStream(String.valueOf(HPATH) + File.separator + TagPileup.generateFileName(BED.getName(), BAM.getName(), 2)) : new PrintStream(TagPileup.generateFileName(BED.getName(), BAM.getName(), 2));
                    }
                    catch (FileNotFoundException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        ExecutorService parseMaster = Executors.newFixedThreadPool(CPU);
        if (INPUT.size() < CPU) {
            CPU = INPUT.size();
        }
        int subset = 0;
        int currentindex = 0;
        int x = 0;
        while (x < CPU) {
            int remainder;
            subset = CPU == 1 ? INPUT.size() : (INPUT.size() % CPU == 0 ? INPUT.size() / CPU : (x < (remainder = INPUT.size() % CPU) ? (int)((double)INPUT.size() / (double)CPU + 1.0) : (int)((double)INPUT.size() / (double)CPU)));
            PileupExtract extract = new PileupExtract(PARAM, BAM, INPUT, currentindex += subset, subset);
            parseMaster.execute(extract);
            ++x;
        }
        parseMaster.shutdown();
        while (!parseMaster.isTerminated()) {
        }
        double[] AVG_S1 = new double[TagPileup.getMaxBEDSize(INPUT)];
        double[] AVG_S2 = null;
        if (STRAND == 0) {
            AVG_S2 = new double[AVG_S1.length];
        }
        double[] DOMAIN = new double[AVG_S1.length];
        int OUTSTART = 0;
        if (PARAM.getTrans() == 1) {
            OUTSTART = PARAM.getSmooth();
        } else if (PARAM.getTrans() == 2) {
            OUTSTART = PARAM.getStdSize() * PARAM.getStdNum();
        }
        if (PARAM.getOutputType() == 2) {
            if (OUT_S1 != null) {
                OUT_S1.print("YORF\tNAME");
            }
            if (OUT_S2 != null) {
                OUT_S2.print("YORF\tNAME");
            }
            i = OUTSTART;
            while (i < AVG_S1.length - OUTSTART) {
                int index = i - OUTSTART;
                if (OUT_S1 != null) {
                    OUT_S1.print("\t" + index);
                }
                if (OUT_S2 != null) {
                    OUT_S2.print("\t" + index);
                }
                ++i;
            }
            if (OUT_S1 != null) {
                OUT_S1.println();
            }
            if (OUT_S2 != null) {
                OUT_S2.println();
            }
        }
        i = 0;
        while (i < INPUT.size()) {
            double[] tempF = INPUT.get(i).getFStrand();
            double[] tempR = INPUT.get(i).getRStrand();
            if (OUT_S1 != null) {
                OUT_S1.print(INPUT.get(i).getName());
            }
            if (OUT_S2 != null) {
                OUT_S2.print(INPUT.get(i).getName());
            }
            if (PARAM.getOutputType() == 2) {
                if (OUT_S1 != null) {
                    OUT_S1.print("\t" + INPUT.get(i).getName());
                }
                if (OUT_S2 != null) {
                    OUT_S2.print("\t" + INPUT.get(i).getName());
                }
            }
            int j = 0;
            while (j < tempF.length) {
                if (j >= OUTSTART && j < tempF.length - OUTSTART) {
                    if (OUT_S1 != null) {
                        OUT_S1.print("\t" + tempF[j]);
                    }
                    if (OUT_S2 != null) {
                        OUT_S2.print("\t" + tempR[j]);
                    }
                }
                int n = j;
                AVG_S1[n] = AVG_S1[n] + tempF[j];
                if (AVG_S2 != null) {
                    int n2 = j;
                    AVG_S2[n2] = AVG_S2[n2] + tempR[j];
                }
                ++j;
            }
            if (OUT_S1 != null) {
                OUT_S1.println();
            }
            if (OUT_S2 != null) {
                OUT_S2.println();
            }
            ++i;
        }
        int temp = (int)((double)AVG_S1.length / 2.0 + 0.5);
        int i2 = 0;
        while (i2 < AVG_S1.length) {
            DOMAIN[i2] = (double)((temp - (AVG_S1.length - i2)) * PARAM.getBin()) + 1.0;
            int n = i2;
            AVG_S1[n] = AVG_S1[n] / (double)INPUT.size();
            if (AVG_S2 != null) {
                int n3 = i2;
                AVG_S2[n3] = AVG_S2[n3] / (double)INPUT.size();
            }
            ++i2;
        }
        if (PARAM.getTrans() == 1) {
            AVG_S1 = TransformArray.smoothTran(AVG_S1, PARAM.getSmooth());
            if (AVG_S2 != null) {
                AVG_S2 = TransformArray.smoothTran(AVG_S2, PARAM.getSmooth());
            }
        } else if (PARAM.getTrans() == 2) {
            AVG_S1 = TransformArray.gaussTran(AVG_S1, PARAM.getStdSize(), PARAM.getStdNum());
            if (AVG_S2 != null) {
                AVG_S2 = TransformArray.gaussTran(AVG_S2, PARAM.getStdSize(), PARAM.getStdNum());
            }
        }
        double[] AVG_S1_trim = new double[AVG_S1.length - OUTSTART * 2];
        double[] AVG_S2_trim = null;
        if (STRAND == 0) {
            AVG_S2_trim = new double[AVG_S1_trim.length];
        }
        double[] DOMAIN_trim = new double[AVG_S1_trim.length];
        int i3 = OUTSTART;
        while (i3 < AVG_S1.length - OUTSTART) {
            if (AVG_S2 != null) {
                AVG_S2_trim[i3 - OUTSTART] = AVG_S2[i3];
            }
            AVG_S1_trim[i3 - OUTSTART] = AVG_S1[i3];
            DOMAIN_trim[i3 - OUTSTART] = DOMAIN[i3];
            ++i3;
        }
        AVG_S1 = AVG_S1_trim;
        AVG_S2 = AVG_S2_trim;
        DOMAIN = DOMAIN_trim;
        if (COMPOSITE != null) {
            int a = 0;
            while (a < DOMAIN.length) {
                COMPOSITE.print("\t" + DOMAIN[a]);
                ++a;
            }
            COMPOSITE.println();
            if (STRAND == 0) {
                COMPOSITE.print(TagPileup.generateFileName(BED.getName(), BAM.getName(), 0));
                a = 0;
                while (a < AVG_S1.length) {
                    COMPOSITE.print("\t" + AVG_S1[a]);
                    ++a;
                }
                COMPOSITE.println();
                COMPOSITE.print(TagPileup.generateFileName(BED.getName(), BAM.getName(), 1));
                a = 0;
                while (a < AVG_S2.length) {
                    COMPOSITE.print("\t" + AVG_S2[a]);
                    ++a;
                }
                COMPOSITE.println();
            } else {
                COMPOSITE.print(TagPileup.generateFileName(BED.getName(), BAM.getName(), 2));
                a = 0;
                while (a < AVG_S1.length) {
                    COMPOSITE.print("\t" + AVG_S1[a]);
                    ++a;
                }
                COMPOSITE.println();
            }
        }
        if (OUT_S1 != null && PARAM.getOutputType() == 2) {
            OUT_S1.close();
        }
        if (OUT_S2 != null && PARAM.getOutputType() == 2) {
            OUT_S2.close();
        }
    }

    public static String generateFileName(String bed, String bam, int strandnum) {
        String[] bedname = bed.split("\\.");
        String[] bamname = bam.split("\\.");
        String strand = "sense";
        if (strandnum == 1) {
            strand = "anti";
        } else if (strandnum == 2) {
            strand = "combined";
        }
        String read = "read1";
        if (PARAM.getRead() == 1) {
            read = "read2";
        } else if (PARAM.getRead() == 2) {
            read = "readc";
        }
        String filename = String.valueOf(bedname[0]) + "_" + bamname[0] + "_" + read + "_" + strand + ".tabular";
        return filename;
    }

    public static Vector<BEDCoord> loadCoord(File INPUT) throws FileNotFoundException {
        Scanner scan = new Scanner(INPUT);
        Vector<BEDCoord> c = new Vector<BEDCoord>();
        while (scan.hasNextLine()) {
            Object[] temp = scan.nextLine().split("\t");
            if (temp.length <= 2 || temp[0].contains("track") || temp[0].contains("#")) continue;
            String name = "";
            name = temp.length > 3 ? temp[3] : String.valueOf(temp[0]) + "_" + temp[1] + "_" + (String)temp[2];
            if (Integer.parseInt(temp[1]) >= 0) {
                if (temp.length > 4) {
                    if (temp[5].equals("+")) {
                        c.add(new BEDCoord((String)temp[0], Integer.parseInt((String)temp[1]), Integer.parseInt((String)temp[2]), "+", name));
                        continue;
                    }
                    c.add(new BEDCoord((String)temp[0], Integer.parseInt((String)temp[1]), Integer.parseInt((String)temp[2]), "-", name));
                    continue;
                }
                c.add(new BEDCoord((String)temp[0], Integer.parseInt((String)temp[1]), Integer.parseInt((String)temp[2]), "+", name));
                continue;
            }
            System.out.println("Invalid Coordinate in File!!!\n" + Arrays.toString(temp));
        }
        scan.close();
        return c;
    }

    public static void loadConfig(String[] command) {
        int i = 0;
        while (i < command.length) {
            switch (command[i].charAt(1)) {
                case 'b': {
                    BAM = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'i': {
                    BAI = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'c': {
                    BED = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 's': {
                    SHIFT = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'n': {
                    BINSIZE = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'e': {
                    TAGSEQUAL = Boolean.parseBoolean(command[i + 1]);
                    ++i;
                    break;
                }
                case 'r': {
                    READ = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'a': {
                    STRAND = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'p': {
                    PE_STATUS = Boolean.parseBoolean(command[i + 1]);
                    ++i;
                    break;
                }
                case 't': {
                    CPU = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'w': {
                    SMOOTHWINDOW = Integer.parseInt(command[i + 1]);
                    ++i;
                    break;
                }
                case 'h': {
                    OUTPUT_HEATMAP = Boolean.parseBoolean(command[i + 1]);
                    ++i;
                    break;
                }
                case 'm': {
                    OUTPUT_COMP = Boolean.parseBoolean(command[i + 1]);
                    ++i;
                    break;
                }
                case 'o': {
                    HPATH = command[i + 1];
                    ++i;
                    break;
                }
                case 'x': {
                    CNAME = command[i + 1];
                    ++i;
                }
            }
            ++i;
        }
        if (BAM == null) {
            System.err.println("No BAM File loaded!!!\n");
            TagPileup.printUsage();
            System.exit(1);
        } else if (BAI == null) {
            System.err.println("No BAI Index File loaded!!!\n");
            TagPileup.printUsage();
            System.exit(1);
        } else if (BED == null) {
            System.err.println("No BED File loaded!!!\n");
            TagPileup.printUsage();
            System.exit(1);
        }
        if (BINSIZE < 1) {
            System.err.println("Invalid Bin Size!!! Must be larger than 0 bp");
            TagPileup.printUsage();
            System.exit(1);
        } else if (READ < 0 || READ > 2) {
            System.err.println("Invalid Read to Examine!!! Select 0-2");
            TagPileup.printUsage();
            System.exit(1);
        } else if (CPU < 1) {
            System.err.println("Invalid Number of CPU's!!! Must use at least 1");
            TagPileup.printUsage();
            System.exit(1);
        } else if (SMOOTHWINDOW < 0) {
            System.err.println("Invalid Smoothing Window Size!!! Must be larger than 0 bp");
            TagPileup.printUsage();
            System.exit(1);
        }
        PARAM = new PileupParameters();
        PARAM.setShift(SHIFT);
        PARAM.setBin(BINSIZE);
        PARAM.setStandard(TAGSEQUAL);
        PARAM.setRead(READ);
        PARAM.setPErequire(PE_STATUS);
        if (STRAND == 0) {
            PARAM.setStrand(0);
            PARAM.setSenseColor(Color.BLUE);
            PARAM.setAntiColor(Color.RED);
        } else {
            PARAM.setStrand(1);
            PARAM.setCombinedColor(new Color(0, 100, 0));
        }
        PARAM.setCPU(CPU);
        if (SMOOTHWINDOW > 0) {
            PARAM.setTrans(1);
            PARAM.setSmooth(SMOOTHWINDOW);
        } else {
            PARAM.setTrans(0);
        }
        if (!OUTPUT_HEATMAP) {
            PARAM.setOutputType(0);
        } else {
            PARAM.setOutputType(2);
        }
        if (!OUTPUT_HEATMAP && !OUTPUT_COMP) {
            PARAM.setOutput(null);
        } else {
            PARAM.setOutput(new File(System.getProperty("user.dir")));
        }
        PARAM.setOutputCompositeStatus(OUTPUT_COMP);
        System.out.println("-----------------------------------------\nCommand Line Arguments:");
        System.out.println("BAM file: " + BAM);
        System.out.println("BAI file: " + BAI);
        System.out.println("BED file: " + BED);
        System.out.println("\nGlobal transformations:");
        System.out.println("5' to 3' Tag Shift (bp):\t" + SHIFT);
        System.out.println("Bin Size (bp):\t\t\t" + BINSIZE);
        System.out.println("Set Tags to be equal:\t\t" + TAGSEQUAL);
        System.out.println("\nRead parameters:");
        System.out.println("Reads to Examine:\t\t" + READ);
        System.out.println("Require Proper PE:\t\t" + PE_STATUS);
        System.out.println("Combine Strands:\t\t" + STRAND);
        System.out.println("\nRun parameters:");
        System.out.println("CPUs to use:\t\t\t" + CPU);
        System.out.println("Composite smoothing window (bp):" + SMOOTHWINDOW);
        System.out.println("Output heatmap:\t\t\t" + OUTPUT_HEATMAP);
        System.out.println("Output path for heatmap:\t" + HPATH);
        System.out.println("Output composite:\t\t" + OUTPUT_COMP);
        System.out.println("Output filename for composite:\t" + CNAME);
    }

    public static void printUsage() {
        System.err.println("Usage: java -jar TagPileup.jar -b [BAMFile] -c [BEDFile] [Options]");
        System.err.println("-----------------------------------------");
        System.err.println("\nRequired Parameter:");
        System.err.println("BAM File:\t\t\t-b\tBAM file");
        System.err.println("BAI File:\t\t\t-i\tBAI file");
        System.err.println("BED File:\t\t\t-c\tBED file");
        System.err.println("\nOptional Parameters:");
        System.err.println("\nGlobal transformations:");
        System.err.println("5' to 3' Tag Shift (bp):\t-s\t0 (default)");
        System.err.println("Bin Size (bp):\t\t\t-n\t1 (default)");
        System.err.println("Set Tags to be equal:\t\t-e\tfalse (default), true");
        System.err.println("\nRead parameters:");
        System.err.println("Reads to Examine:\t\t-r\t0 - Read 1 (default), 1 - Read 2, 2 - Combined");
        System.err.println("Require Proper PE:\t\t-p\tfalse (default), true");
        System.err.println("Combine Strands:\t\t-a\t0 - Strand seperate (default), 1 - Strand combined");
        System.err.println("\nRun parameters:");
        System.err.println("CPUs to use:\t\t\t-t\t1 (default)");
        System.err.println("Composite smoothing window (bp):-w\t0 (default)");
        System.err.println("Output heatmap:\t\t\t-h\ttrue (default), false");
        System.err.println("Output composite:\t\t-m\ttrue (default), false");
        System.err.println("Output path for heatmap:\t-o\tDefault local path");
        System.err.println("Output filename for composite:\t-x\tcomposite.out (default)");
    }

    private static String getTimeStamp() {
        Date date = new Date();
        String time = new Timestamp(date.getTime()).toString();
        return time;
    }
}

