/*
 * Decompiled with CFR 0.152.
 */
package PileupScripts;

import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.IOException;

public class BAMUtilities {
    public static double calculateStandardizationRatio(File BAM) throws IOException {
        SamReader inputSam = SamReaderFactory.makeDefault().open(BAM);
        AbstractBAMFileIndex bai = (AbstractBAMFileIndex)inputSam.indexing().getIndex();
        double counter = 0.0;
        double totalAligned = 0.0;
        double totalGenome = 0.0;
        int x = 0;
        while (x < bai.getNumberOfReferences()) {
            SAMSequenceRecord seq = inputSam.getFileHeader().getSequence(x);
            totalAligned += (double)inputSam.indexing().getIndex().getMetaData(x).getAlignedRecordCount();
            totalGenome += (double)seq.getSequenceLength();
            ++x;
        }
        SAMRecordIterator iter = inputSam.iterator();
        while (iter.hasNext()) {
            SAMRecord sr = (SAMRecord)iter.next();
            if (!sr.getReadPairedFlag() || !sr.getSecondOfPairFlag()) continue;
            counter += 1.0;
        }
        inputSam.close();
        bai.close();
        iter.close();
        totalAligned -= counter;
        if (totalAligned > 0.0) {
            return totalAligned / totalGenome;
        }
        return 1.0;
    }
}

