#! /usr/bin/perl

my($input, $SIZE) = @ARGV;
open(IN, "<$input") or die "Can't open $input for reading!\n";

#chr1	genetrack	.	123950	123970	22	+	.	stddev=0.0
#chr1	genetrack	.	565745	565765	12	+	.	stddev=0.0
#chr1	genetrack	.	565793	565813	44	+	.	stddev=0.298065387468

$line = "";
while($line = <IN>) {
	chomp($line);
	@array = split(/\t/, $line);
	
	$CENTER = int(($array[3] + $array[4]) / 2);
	if(($array[4] - $array[3]) % 2 != 0 || $array[6] eq "-") { $CENTER++; }
	$START = $CENTER - ($SIZE / 2);
	$STOP = $CENTER + (($SIZE / 2) - 1);
	
	if($START < 1) { print STDERR "Error:\t$line\nRequested expansion places region beyond chromosome bounds!!!\n"; }
	else {
		print "$array[0]\t$array[1]\t$array[2]\t$START\t$STOP";
		for($x = 5; $x <= $#array; $x++) { print "\t$array[$x]"; }
		print "\n";
	}
}
close IN;
