/*
 * Decompiled with CFR 0.152.
 */
package pairedendCrossPlot;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.Scanner;

public class pairedendCrossPlot {
    private static File READ1 = null;
    private static File READ2 = null;
    private static File OUTPUT = null;
    private static int WINDOW = 500;
    private static int[] BP = null;
    private static int[] FOR = null;
    private static int[] REV = null;
    private static ArrayList<String> chrName = null;
    private static ArrayList<Integer> chrStart = null;
    private static int[] FHIST = null;
    private static int[] RHIST = null;

    public static void main(String[] args) throws FileNotFoundException {
        pairedendCrossPlot.loadConfig(args);
        FHIST = new int[WINDOW * 2 + 1];
        RHIST = new int[WINDOW * 2 + 1];
        System.out.println("\n" + pairedendCrossPlot.getTimeStamp());
        System.out.println("Indexing Read 2 File...");
        pairedendCrossPlot.indexFile(READ2);
        System.out.println("Indexing Complete\n" + pairedendCrossPlot.getTimeStamp());
        System.out.println("\n" + pairedendCrossPlot.getTimeStamp() + "\nParsing Read 1 File...");
        pairedendCrossPlot.parseRead1(READ1);
        System.out.println("\nRead 1 Parsed\n" + pairedendCrossPlot.getTimeStamp());
        System.out.println("\nOutputing final histogram...");
        pairedendCrossPlot.outputHist(OUTPUT);
        System.out.println("Program Complete\n" + pairedendCrossPlot.getTimeStamp());
    }

    public static void outputHist(File out) throws FileNotFoundException {
        PrintStream OUT = new PrintStream(out);
        int x = WINDOW * -1;
        while (x <= WINDOW) {
            OUT.print("\t" + x);
            ++x;
        }
        OUT.print("\nForward_Tags");
        x = 0;
        while (x < FHIST.length) {
            OUT.print("\t" + FHIST[x]);
            ++x;
        }
        OUT.print("\nReverse_Tags");
        x = 0;
        while (x < RHIST.length) {
            OUT.print("\t" + RHIST[x]);
            ++x;
        }
        OUT.close();
    }

    public static void parseRead1(File input) throws FileNotFoundException {
        Scanner scan = new Scanner(READ1);
        String currentChrom = "";
        int currentIndex = 0;
        while (scan.hasNextLine()) {
            String temp = scan.nextLine();
            if (temp.contains("index") || temp.contains("#")) continue;
            String[] array = temp.split("\t");
            int POS = Integer.parseInt(array[1]);
            int F = Integer.parseInt(array[2]);
            int R = Integer.parseInt(array[3]);
            if (!currentChrom.equals(array[0])) {
                BP = null;
                int newIndex = chrName.indexOf(array[0]);
                if (newIndex >= 0) {
                    System.out.println("\nLoading: " + chrName.get(newIndex));
                    pairedendCrossPlot.loadRead2(READ2, chrName.get(newIndex), chrStart.get(newIndex), chrStart.get(newIndex + 1));
                    currentChrom = array[0];
                    currentIndex = 0;
                    System.out.println("Loading Complete\n" + pairedendCrossPlot.getTimeStamp());
                }
            }
            if (BP == null) continue;
            while (POS - WINDOW > BP[currentIndex] && currentIndex < BP.length - 1) {
                ++currentIndex;
            }
            int currentStop = currentIndex;
            while (POS + WINDOW > BP[currentStop] && currentStop < BP.length - 1) {
                ++currentStop;
            }
            int[] temp_F = new int[WINDOW * 2 + 1];
            int[] temp_R = new int[WINDOW * 2 + 1];
            int x = currentIndex;
            while (x <= currentStop) {
                int index = BP[x] - POS + WINDOW;
                if (index >= 0 && index < temp_F.length) {
                    int n = index;
                    temp_F[n] = temp_F[n] + FOR[x];
                    int n2 = index;
                    temp_R[n2] = temp_R[n2] + REV[x];
                }
                ++x;
            }
            x = 0;
            while (x < temp_F.length) {
                int n = x;
                FHIST[n] = FHIST[n] + temp_F[x] * F;
                int n3 = x;
                RHIST[n3] = RHIST[n3] + temp_R[x] * F;
                ++x;
            }
            x = 0;
            while (x < FHIST.length / 2) {
                int tempF = temp_F[x];
                int tempR = temp_R[x];
                temp_F[x] = temp_F[temp_F.length - x - 1];
                temp_F[temp_F.length - x - 1] = tempF;
                temp_R[x] = temp_R[temp_R.length - x - 1];
                temp_R[temp_R.length - x - 1] = tempR;
                ++x;
            }
            x = 0;
            while (x < FHIST.length) {
                int n = x;
                FHIST[n] = FHIST[n] + temp_R[x] * R;
                int n4 = x;
                RHIST[n4] = RHIST[n4] + temp_F[x] * R;
                ++x;
            }
        }
        scan.close();
    }

    private static void loadRead2(File input, String currentChrom, int lineStart, int lineStop) throws FileNotFoundException {
        BP = new int[lineStop - lineStart - 1];
        FOR = new int[lineStop - lineStart - 1];
        REV = new int[lineStop - lineStart - 1];
        int counter = 0;
        Scanner scan = new Scanner(READ2);
        while (scan.hasNextLine()) {
            String[] array;
            String temp = scan.nextLine();
            if (counter > lineStart && (array = temp.split("\t"))[0].equals(currentChrom)) {
                pairedendCrossPlot.BP[counter - lineStart - 1] = Integer.parseInt(array[1]);
                pairedendCrossPlot.FOR[counter - lineStart - 1] = Integer.parseInt(array[2]);
                pairedendCrossPlot.REV[counter - lineStart - 1] = Integer.parseInt(array[3]);
            }
            ++counter;
        }
        scan.close();
    }

    public static void indexFile(File input) throws FileNotFoundException {
        chrName = new ArrayList();
        chrStart = new ArrayList();
        Scanner scan = new Scanner(input);
        int linenumber = 0;
        while (scan.hasNextLine()) {
            String[] array;
            String temp = scan.nextLine();
            if (!(temp.contains("index") || temp.contains("#") || chrName.contains((array = temp.split("\t"))[0]))) {
                chrName.add(array[0]);
                chrStart.add(new Integer(linenumber));
            }
            ++linenumber;
        }
        chrStart.add(new Integer(linenumber));
        scan.close();
    }

    public static void loadConfig(String[] command) {
        int i = 0;
        while (i < command.length) {
            switch (command[i].charAt(1)) {
                case 'f': {
                    READ1 = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'r': {
                    READ2 = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'o': {
                    OUTPUT = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'w': {
                    WINDOW = Integer.parseInt(command[i + 1]);
                    ++i;
                }
            }
            ++i;
        }
        if (READ1 == null) {
            System.out.println("No Read 1 File loaded!!!\n");
            pairedendCrossPlot.printUsage();
            System.exit(0);
        }
        if (READ2 == null) {
            System.out.println("No Read 2 File loaded!!!\n");
            pairedendCrossPlot.printUsage();
            System.exit(0);
        }
        if (WINDOW < 1) {
            System.out.println("Invalid Window Size Selected!!!\n");
            pairedendCrossPlot.printUsage();
            System.exit(0);
        }
        if (OUTPUT == null) {
            OUTPUT = new File(String.valueOf(READ1.getName().split("\\.")[0]) + ".out");
        }
        System.out.println("-----------------------------------------\nCommand Line Arguments:");
        System.out.println("Read 1 file: " + READ1);
        System.out.println("Read 2 file: " + READ2);
        System.out.println("Output: " + OUTPUT);
        System.out.println("Window Size: " + WINDOW);
    }

    public static void printUsage() {
        System.out.println("Usage: java -jar pairedendCrossPlot.jar -f [Read1File] -r [Read2File] [Options]");
        System.out.println("-----------------------------------------");
        System.out.println("\nRequired Parameter:");
        System.out.println("Read 1 File:\t\t\t-f\tRead 1 scIDX file");
        System.out.println("Read 2 File:\t\t\t-r\tRead 1 scIDX file");
        System.out.println("\nOptional Parameters:");
        System.out.println("Output File Name:\t\t-o\tOutput file");
        System.out.println("Window Size +/- Reference:\t-w\t(Default = 500)");
    }

    private static String getTimeStamp() {
        Date date = new Date();
        String time = new Timestamp(date.getTime()).toString();
        return time;
    }
}

