import optparse
import os
import sys

parser = optparse.OptionParser()
parser.add_option('--threads', dest='threads', type="string", help='The number of threads to run')
parser.add_option('--input_files', dest='input_file', action='append', nargs='1', type="string", help='Input datasets')

parser.add_option('--genome_info_file', dest='genome_info_file', type="string", help='Genome information file')
parser.add_option('--replicate_available', dest='replicate_available', type="string", help='Are the selected inputs biological replicates')
parser.add_option('--smoothing_factor', dest='smoothing_factor', type="int", help='Gaussian smoothing standard deviation')
parser.add_option('--output_report', dest='output_report', type="string", help='MultiGPS output report')
parser.add_option('--gff', dest='gff', type="string", help='...')
parser.add_option('--gz', dest='gz', type="string", help='...')
parser.add_option('--design_file', dest='design_file', type="string", help='...')

options, args = parser.parse_args()

dh = open('/tmp/out.log', 'wb')
dh.write( '\n options: \n%s\n' % str( options))
dh.write( '\n args: \n%s\n' % str( args))
dh.close()
sys,stderr.write('Finished...')
sys.exit(1)


genome = options.genome
input_format = options.input_format
replicate = options.replicate
smooth = options.smooth
output_file = options.report
output_file2 = options.gff
output_file3 = options.gz
# input_file = sys.argv[8]
design_file = options.design_file
input_file = options.input_files[0]
if len(options.input_files) > 1:
	design_arg = '--design %s' % design_file
else:
	design_arg = ''
print file(design_file, 'r').read()

tmp_name = output_file.split("/")
tmp_name = tmp_name[len(tmp_name)-1]

input_tmp_name = input_file.split("/")
input_tmp_name = input_tmp_name[len(input_tmp_name)-1]
tmp_name2 = input_tmp_name.split(".")

f = open("/home/galaxy/galaxy-dist/tools/pughlab/command_tmp/"+tmp_name+".pbs","w")
f.write("cd /home/galaxy/galaxy-dist/tools/pughlab/command_tmp/\n")
f.write("mkdir "+tmp_name+"_analysis_result\n")
f.write("cd "+tmp_name+"_analysis_result\n")
f.write("ln -s "+input_file+" .\n")

# cnt = 1
# for ele in filenames:
# 	if replicate == "Yes":
# 		f.write("echo '"+ele+"\tSignal\t"+input_format+"\tDemoExp\t"+str(cnt)+"' >> target.design\n")
# 	else:
# 		f.write("echo '"+ele+"\tSignal\t"+input_format+"\tDemoExp"+str(cnt)+"\t"+str(cnt)+"' >> target.design\n")
# 	cnt = cnt + 1
f.write("java -Xmx6G -jar /home/galaxy/software/multigps/multigps_v0.5.jar --geninfo /home/galaxy/software/multigps/"+genome+".info --threads 4 "+design_arg+" --verbose --gaussmodelsmoothing --gausssmoothparam "+smooth+" --out multigps_out --memepath ~/bin --mememinw 6 --mememaxw 16 --seq /home/galaxy/software/multigps/refs/"+genome+" >multiGPS.out 2>&1\n")
f.write("rm -rf "+output_file+"\n")
f.write("mv multigps_out/multigps_out.all.events.table "+output_file+"\n")
f.write("tar cvzf multigps_out.tar.gz multigps_out\n")
f.write("mv multigps_out.tar.gz "+output_file3+"\n")

f.close()

os.system("sh /home/galaxy/galaxy-dist/tools/pughlab/command_tmp/"+tmp_name+".pbs 2>&1")

f2 = open(output_file, "r")
f3 = open(output_file2, "w")
for line in f2:
	line = line.strip()
	data = line.split("\t")
	if line[:1] != "#":
		chrom = data[0].split(":")
		f3.write(chrom[0]+"\tmultigps\t.\t"+chrom[1]+"\t"+chrom[1]+"\t"+data[1]+"\t.\t.\t.\n")
f3.close()
f2.close()
exit(0)
