#!/usr/bin/env python
import argparse
import collections

parser = argparse.ArgumentParser()
parser.add_argument('--input', dest='input', help='Input bed dataset')
parser.add_argument('--output', dest='output', help='Output window positions by chromosome dataset')

args = parser.parse_args()

chroms = collections.OrderedDict()

with open(args.input, 'r') as fh:
    for count, line in enumerate(fh):
        line = line.strip()
        if not line or line.startswith('#'):
            # Skip blank lines and comments.
            continue
        items = line.split('\t')
        chrom = items[0]
        if count == 0:
            # First window.
            chroms[chrom] = [0, count+1]
        elif chrom in chroms:
            # Get the start / end tuple.
            tup = chroms[chrom]
            # Increment end by 1.
            tup[1] += 1
            chroms[chrom] = tup
        else:
            # chrom not in chroms.
            chroms[chrom] = [count, count+1]

with open(args.output, 'w') as fh:
    for k, v in chroms.items():
        fh.write('%s %d %d\n' % (k, v[0], v[1]))
