#!/usr/bin/env Rscript

suppressPackageStartupMessages(library("optparse"))

option_list <- list(
    make_option(c("-i", "--input"), action="store", dest="input", help="Input .bed.gz file produced by prepMat"),
    make_option(c("-o", "--output"), action="store", dest="output", help="Output file"),
    make_option(c("-w", "--work_dir"), action="store", dest="work_dir", help="Working directory")
)

parser <- OptionParser(usage="%prog [options] file", option_list=option_list)
args <- parse_args(parser, positional_arguments=TRUE)
opt <- args$options

r_matrix <- as.matrix(read.table(opt$input));
status <- match(r_matrix[,3], missing); 
r_matrix[,3] <- paste(opt$work_dir, r_matrix[,1], ".", r_matrix[,2], ".bed.gz", sep="");
r_matrix <- r_matrix[is.na(status)==TRUE,];
write.table(array(r_matrix, dim=c(length(r_matrix)/3, 3)), file=opt$output, quote=FALSE, row.names=FALSE, col.names=FALSE);
