#!/usr/bin/env python
import argparse
import shutil

import icqsol_utils
from icqsol.shapes.icqShapeManager import ShapeManager

# Parse Command Line.
parser = argparse.ArgumentParser()
parser.add_argument( '--input', dest='input', help='Shape dataset selected from history' )
parser.add_argument( '--field_name', dest='field_name', help='Surface field name' )
parser.add_argument( '--expression', dest='expression', help='Expression for applying surface field to shape' )
parser.add_argument( '--time_point', dest='time_points', type=float, action='append', nargs=1, help='Points in time' )
parser.add_argument( '--output', dest='output', help='Output dataset' )
parser.add_argument( '--output_format_and_type', dest='output_format_and_type', help='Output file format and type' )

args = parser.parse_args()

valid_field_name = args.field_name.replace( ' ', '_' )
tmp_dir = icqsol_utils.get_temp_dir()
shape_mgr = ShapeManager()

# Get the shape from the input dataset.
shape = shape_mgr.load(args.input)
# Get the points from the shape.
pdata = shape_mgr.shapeToVTKPolyData(shape)
points = pdata.GetPoints()
num_points = points.GetNumberOfPoints()
# Define the data.
data = vtk.vtkDoubleArray()
data.SetName(valid_field_name)
# Handle time points.
time_points = [ '%.1f' % tp for tp in args.time_points ]
num_time_points = len(time_points)
# Update the data.
data.SetNumberOfComponents(num_time_points)
data.SetNumberOfTuples(num_points)
# Add the surface field.
for i in range(num_points):
    x, y, z = points.GetPoint(i)
    for j in range(num_time_points):
        t = time_points[ j ]
        field_value = eval(args.expression)
        data.SetComponent(i, j, field_value)
pdata.GetPointData().SetScalars(data)

# Define the output file format and type.
output_format, output_file_type = icqsol_utils.get_format_and_type( args.output_format_and_type )
tmp_output_path = icqsol_utils.get_temporary_file_path( tmp_dir, output_format )

# Save the output.
shape_mgr.save( composite_shape, file_name=tmp_output_path, file_format=output_format, file_type=output_file_type )
shutil.move( tmp_output_path, args.output )
