#!/bin/bash

IFS=$'\n';
residue_list=""
hetsys_list=""
hoh_list=""

for line in $(cat $1); do
	if [ "${line:0:4}" = "ATOM"  ];then
		residue_list+="${line:23:6}\n"
	else
		if [ "${line:0:6}" = "HETATM"  ];then
			s2=`echo $line | grep HOH`
			if [ "$s2" != "" ];then
				hoh_list+="${line:21:8}\n"
			else
				s3=`echo $line | grep WAT`
				if [ "$s3" != "" ];then
					hoh_list+="${line:21:8}\n"
				else
					hetsys_list+="${line:21:8}\n"
				fi
			fi
		fi
	fi
done

IFS=$' ';
let num_res=`echo -e "\n"$residue_list | uniq | wc -l`
let num_hoh=`echo -e "\n"$hoh_list | uniq | wc -l`
let num_hetsys=`echo -e "\n"$hetsys_list | uniq | wc -l`

# empty line at begin and end of lists -> substract 2
let num_res-=2
let num_hoh-=2
let num_hetsys-=2
if [ $num_res -lt 0 ]; then
	let num_res=0
fi
if [ $num_hoh -lt 0 ]; then
	let num_hoh=0
fi
if [ $num_hetsys -lt 0 ]; then
	let num_hetsys=0
fi

echo -n "$num_res "
if [ $num_res -eq 1 ]; then
	echo "residue"
else
	echo "residues"
fi
echo -n "$num_hoh water "
if [ $num_hoh -eq 1 ]; then
	echo "molecule"
else
	echo "molecules"
fi
echo -n "$num_hetsys "
if [ $num_hetsys -eq 1 ]; then
	echo "heterosystem"
else
	echo "heterosystems"
fi
