#!/usr/bin/env python

import datetime
import json
import os
import subprocess
import sys

today = datetime.date.today()
with open(sys.argv[1]) as fh:
    params = json.load(fh)
target_directory = params['output_data'][0]['extra_files_path']
os.mkdir(target_directory)
param_dict = params['param_dict']

# Now DRAM-setup.py can be called to download the data.
cmd = 'DRAM-setup.py prepare_database --dbcan_version %d --threads %d' % (param_dict['--dbcan_version'], param_dict['--threads'])
if '--skip_uniref' in param_dict:
    cmd = '%s --skip_uniref' % cmd
else:
    cmd = '%s --uniref_version %d' % param_dict['--uniref_version']
if '--keep_database_files' in param_dict:
    cmd = '%s --keep_database_files' % cmd

subprocess.check_call(cmd, shell=True)

# Prepare the metadata for the new data table record.
data_manager_dict = {
    'data_tables': {
        'dram_versioned_databases': [
            {
                'value': today.isoformat(),
                'version': param_dict['dram_db_version'],
                'name': 'DRAM databases version %s' % param_dict['dram_db_version'],
                'path': None
            }
        ]
    }
}

# Save it to the json results file.
with open(sys.argv[1], 'w') as fh:
    json.dump(data_manager_dict, fh, sort_keys=True)
