#!/usr/bin/env Rscript

options_list <- list(
    make_option(c("-i", "--input_temperatures"), action="store", help="Input temperatures csv file"),
    make_option(c("-s", "--save_log"), action="store_true", default=FALSE, help="Save R logs"),
    make_option(c("-m", "--output_r_log"), action="store", help="Output dataset for R logs"),
    make_option(c("-o", "--output"), action="store", help="Output dataset")
)

parser <- OptionParser(usage="%prog [options] file", options_list)
args <- parse_args(parser, positional_arguments=TRUE)
opt <- args$options


if (opt$save_log) {
    rlogf <- file(opt$output_r_log, open="wt")
} else {
    # Direct R messaging to a temporary file.
    rlogf <- file("tmpRLog", open="wt")
}
sink(file=rlogf, type=c("output", "message"), append=FALSE, split=FALSE)

tempdata <- read.csv(opt$input_temperatures)
save(tempdata, file=opt$output)
