/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.processor.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import htsjdk.samtools.util.CloseableIterator;
import java.util.Collection;
import java.util.Iterator;

public class PredicateFilterDecoratingClosableIterator<T>
implements CloseableIterator<T> {
    final CloseableIterator<T> underlyingIterator;
    final Iterator<T> filteredIterator;

    public PredicateFilterDecoratingClosableIterator(CloseableIterator<T> underlyingIterator, Collection<Predicate<T>> predicates) {
        Preconditions.checkArgument(!predicates.isEmpty(), "predicates must not be empty");
        Iterator<T> nestedPredicateIterator = underlyingIterator;
        for (Predicate<T> predicate : predicates) {
            nestedPredicateIterator = Iterators.filter(nestedPredicateIterator, predicate);
        }
        this.filteredIterator = nestedPredicateIterator;
        this.underlyingIterator = underlyingIterator;
    }

    @Override
    public boolean hasNext() {
        return this.filteredIterator.hasNext();
    }

    @Override
    public T next() {
        return this.filteredIterator.next();
    }

    @Override
    public void close() {
        this.underlyingIterator.close();
    }

    @Override
    public void remove() {
        this.underlyingIterator.remove();
    }
}

