/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.ListMap;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.GenotypeBuilder;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.VariantContextBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import picard.vcf.filter.GenotypeFilter;
import picard.vcf.filter.VariantFilter;

public class FilterApplyingVariantIterator
implements CloseableIterator<VariantContext> {
    public static final String ALL_GTS_FILTERED = "AllGtsFiltered";
    public static final String PASS_FILTER = "PASS";
    private final Iterator<VariantContext> iterator;
    private final VariantFilter[] filters;
    private final GenotypeFilter[] gtFilters;

    public FilterApplyingVariantIterator(Iterator<VariantContext> iterator, Collection<VariantFilter> filters, Collection<GenotypeFilter> gtFilters) {
        this.iterator = iterator;
        this.filters = filters.toArray(new VariantFilter[filters.size()]);
        this.gtFilters = gtFilters.toArray(new GenotypeFilter[gtFilters.size()]);
    }

    @Override
    public VariantContext next() {
        VariantContext ctx = this.iterator.next();
        HashSet<String> filterStrings = new HashSet<String>();
        for (VariantFilter filter : this.filters) {
            String val = filter.filter(ctx);
            if (val == null) continue;
            filterStrings.add(val);
        }
        ListMap<String, String> gtFilterStrings = new ListMap<String, String>();
        HashSet<String> variantSamples = new HashSet<String>();
        for (Genotype gt : ctx.getGenotypes()) {
            if (gt.isCalled() && !gt.isHomRef()) {
                variantSamples.add(gt.getSampleName());
            }
            for (GenotypeFilter filter : this.gtFilters) {
                String filterString = filter.filter(ctx, gt);
                if (filterString == null) continue;
                gtFilterStrings.add(gt.getSampleName(), filterString);
            }
        }
        if (gtFilterStrings.keySet().containsAll(variantSamples)) {
            filterStrings.add(ALL_GTS_FILTERED);
        }
        VariantContextBuilder builder = new VariantContextBuilder(ctx);
        if (filterStrings.isEmpty()) {
            builder.passFilters();
        } else {
            builder.filters(filterStrings);
        }
        builder.noGenotypes();
        ArrayList<Genotype> newGenotypes = new ArrayList<Genotype>(ctx.getNSamples());
        for (Genotype gt : ctx.getGenotypes()) {
            GenotypeBuilder gtBuilder = new GenotypeBuilder(gt);
            List filters = (List)gtFilterStrings.get(gt.getSampleName());
            if (filters == null || filters.isEmpty()) {
                gtBuilder.filter(PASS_FILTER);
            } else {
                gtBuilder.filters(filters);
            }
            newGenotypes.add(gtBuilder.make());
        }
        builder.genotypes(newGenotypes);
        return builder.make();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove() not supported by FilterApplyingVariantIterator.");
    }
}

