/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMIndexer;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SamInputResource;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Generates a BAM index (.bai) file.", usageShort="Generates a BAM index (.bai) file", programGroup=SamOrBam.class)
public class BuildBamIndex
extends CommandLineProgram {
    private static final Log log = Log.getInstance(BuildBamIndex.class);
    @Option(shortName="I", doc="A BAM file or URL to process. Must be sorted in coordinate order.")
    public String INPUT;
    URL inputUrl = null;
    File inputFile = null;
    @Option(shortName="O", doc="The BAM index file. Defaults to x.bai if INPUT is x.bam, otherwise INPUT.bai.\nIf INPUT is a URL and OUTPUT is unspecified, defaults to a file in the current directory.", optional=true)
    public File OUTPUT;

    public static void main(String[] argv) {
        System.exit(new BuildBamIndex().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        SamReader bam;
        try {
            this.inputUrl = new URL(this.INPUT);
        }
        catch (MalformedURLException e) {
            this.inputFile = new File(this.INPUT);
        }
        if (this.OUTPUT == null) {
            String baseFileName;
            if (this.inputUrl != null) {
                String path = this.inputUrl.getPath();
                int lastSlash = path.lastIndexOf("/");
                baseFileName = path.substring(lastSlash + 1, path.length());
            } else {
                baseFileName = this.inputFile.getAbsolutePath();
            }
            if (baseFileName.endsWith(".bam")) {
                int index = baseFileName.lastIndexOf(".");
                this.OUTPUT = new File(baseFileName.substring(0, index) + ".bai");
            } else {
                this.OUTPUT = new File(baseFileName + ".bai");
            }
        }
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (this.inputUrl != null) {
            bam = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).disable(SamReaderFactory.Option.EAGERLY_DECODE).enable(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS).open(SamInputResource.of(this.inputUrl));
        } else {
            IOUtil.assertFileIsReadable(this.inputFile);
            bam = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).enable(SamReaderFactory.Option.INCLUDE_SOURCE_IN_RECORDS).open(this.inputFile);
        }
        if (bam.type() != SamReader.Type.BAM_TYPE) {
            throw new SAMException("Input file must be bam file, not sam file.");
        }
        if (!bam.getFileHeader().getSortOrder().equals((Object)SAMFileHeader.SortOrder.coordinate)) {
            throw new SAMException("Input bam file must be sorted by coordinates");
        }
        BAMIndexer.createIndex(bam, this.OUTPUT);
        log.info("Successfully wrote bam index file " + this.OUTPUT);
        CloserUtil.close(bam);
        return 0;
    }
}

