/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis.artifacts;

import htsjdk.samtools.util.SequenceUtil;

enum Transition {
    AtoA('A', 'A'),
    AtoC('A', 'C'),
    AtoG('A', 'G'),
    AtoT('A', 'T'),
    CtoA('C', 'A'),
    CtoC('C', 'C'),
    CtoG('C', 'G'),
    CtoT('C', 'T'),
    GtoA('G', 'A'),
    GtoC('G', 'C'),
    GtoG('G', 'G'),
    GtoT('G', 'T'),
    TtoA('T', 'A'),
    TtoC('T', 'C'),
    TtoG('T', 'G'),
    TtoT('T', 'T');

    private static final Transition[] ALT_VALUES;
    private final char ref;
    private final char call;

    private Transition(char ref, char call) {
        this.ref = ref;
        this.call = call;
    }

    public static Transition transitionOf(char ref, char call) {
        return Transition.valueOf(ref + "to" + call);
    }

    public static Transition[] altValues() {
        return ALT_VALUES;
    }

    public Transition complement() {
        return Transition.transitionOf((char)SequenceUtil.complement((byte)this.ref), (char)SequenceUtil.complement((byte)this.call));
    }

    public Transition matchingRef() {
        return Transition.transitionOf(this.ref, this.ref);
    }

    public char ref() {
        return this.ref;
    }

    public char call() {
        return this.call;
    }

    public String toString() {
        return this.ref + ">" + this.call;
    }

    static {
        ALT_VALUES = new Transition[]{AtoC, AtoG, AtoT, CtoA, CtoG, CtoT, GtoA, GtoC, GtoT, TtoA, TtoC, TtoG};
    }
}

