/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SamReader;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SamLocusIterator;
import java.io.File;
import picard.analysis.CollectWgsMetrics;
import picard.analysis.CountingFilter;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;

@CommandLineProgramProperties(usage="Computes a number of metrics that are useful for evaluating coverage and performance of whole genome sequencing experiments, but only at a set of sampled positions.  It is important that the sampled positions be chosen so that they are spread out at least further than a read's length apart; otherwise, you run the risk of double-counting reads in the metrics.", usageShort="Writes whole genome sequencing-related metrics for a SAM or BAM file", programGroup=Metrics.class)
public class CollectWgsMetricsFromSampledSites
extends CollectWgsMetrics {
    @Option(shortName="INTERVALS", doc="An interval list file that contains the locations of the positions to assess.", optional=false)
    public File INTERVALS = null;

    public static void main(String[] args) {
        new CollectWgsMetricsFromSampledSites().instanceMainWithExit(args);
    }

    @Override
    protected SamLocusIterator getLocusIterator(SamReader in) {
        IOUtil.assertFileIsReadable(this.INTERVALS);
        return new SamLocusIterator(in, IntervalList.fromFile(this.INTERVALS));
    }

    @Override
    protected long getBasesExcludedBy(CountingFilter filter) {
        return filter.getFilteredRecords();
    }

    @Override
    protected CollectWgsMetrics.WgsMetrics generateWgsMetrics() {
        return new SampledWgsMetrics();
    }

    public static class SampledWgsMetrics
    extends CollectWgsMetrics.WgsMetrics {
    }
}

