/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.CRAMIndexer;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriterImpl;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SAMTextHeaderCodec;
import htsjdk.samtools.cram.build.ContainerFactory;
import htsjdk.samtools.cram.build.Cram2SamRecordFactory;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.build.CramNormalizer;
import htsjdk.samtools.cram.build.Sam2CramRecordFactory;
import htsjdk.samtools.cram.common.CramVersions;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.lossy.PreservationPolicy;
import htsjdk.samtools.cram.lossy.QualityScorePreservation;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceTracks;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.CramHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.StringLineReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class CRAMFileWriter
extends SAMFileWriterImpl {
    private static final int REF_SEQ_INDEX_NOT_INITIALIZED = -2;
    static int DEFAULT_RECORDS_PER_SLICE = 10000;
    private static final int DEFAULT_SLICES_PER_CONTAINER = 1;
    private static final Version cramVersion = CramVersions.CRAM_v2_1;
    private final String fileName;
    private final List<SAMRecord> samRecords = new ArrayList<SAMRecord>();
    private ContainerFactory containerFactory;
    protected final int recordsPerSlice = DEFAULT_RECORDS_PER_SLICE;
    protected final int containerSize = this.recordsPerSlice * 1;
    private final OutputStream outputStream;
    private ReferenceSource source;
    private int refSeqIndex = -2;
    private static final Log log = Log.getInstance(CRAMFileWriter.class);
    private final SAMFileHeader samFileHeader;
    private boolean preserveReadNames = true;
    private QualityScorePreservation preservation = null;
    private boolean captureAllTags = true;
    private Set<String> captureTags = new TreeSet<String>();
    private Set<String> ignoreTags = new TreeSet<String>();
    private CRAMIndexer indexer;
    private long offset;

    public CRAMFileWriter(OutputStream outputStream, ReferenceSource source, SAMFileHeader samFileHeader, String fileName) {
        this(outputStream, null, source, samFileHeader, fileName);
    }

    public CRAMFileWriter(OutputStream outputStream, OutputStream indexOS, ReferenceSource source, SAMFileHeader samFileHeader, String fileName) {
        this.outputStream = outputStream;
        this.source = source;
        this.samFileHeader = samFileHeader;
        this.fileName = fileName;
        this.setSortOrder(samFileHeader.getSortOrder(), true);
        this.setHeader(samFileHeader);
        if (this.source == null) {
            this.source = new ReferenceSource(Defaults.REFERENCE_FASTA);
        }
        this.containerFactory = new ContainerFactory(samFileHeader, this.recordsPerSlice);
        if (indexOS != null) {
            this.indexer = new CRAMIndexer(indexOS, samFileHeader);
        }
    }

    protected boolean shouldFlushContainer(SAMRecord nextRecord) {
        return this.samRecords.size() >= this.containerSize || this.refSeqIndex != -2 && this.refSeqIndex != nextRecord.getReferenceIndex();
    }

    private static void updateTracks(List<SAMRecord> samRecords, ReferenceTracks tracks) {
        for (SAMRecord samRecord : samRecords) {
            if (samRecord.getAlignmentStart() == 0) continue;
            int refPos = samRecord.getAlignmentStart();
            int readPos = 0;
            for (CigarElement cigarElement : samRecord.getCigar().getCigarElements()) {
                if (cigarElement.getOperator().consumesReferenceBases()) {
                    for (int elementIndex = 0; elementIndex < cigarElement.getLength(); ++elementIndex) {
                        tracks.addCoverage(refPos + elementIndex, 1);
                    }
                }
                switch (cigarElement.getOperator()) {
                    case M: 
                    case X: 
                    case EQ: {
                        for (int pos = readPos; pos < cigarElement.getLength(); ++pos) {
                            byte refBase;
                            byte readBase = samRecord.getReadBases()[readPos + pos];
                            if (readBase == (refBase = tracks.baseAt(refPos + pos))) continue;
                            tracks.addMismatches(refPos + pos, 1);
                        }
                        break;
                    }
                }
                readPos += cigarElement.getOperator().consumesReadBases() ? cigarElement.getLength() : 0;
                refPos += cigarElement.getOperator().consumesReferenceBases() ? cigarElement.getLength() : 0;
            }
        }
    }

    protected void flushContainer() throws IllegalArgumentException, IllegalAccessException, IOException {
        byte[] refs;
        String refSeqName = null;
        if (this.refSeqIndex == -1) {
            refs = new byte[]{};
        } else {
            SAMSequenceRecord sequence = this.samFileHeader.getSequence(this.refSeqIndex);
            refs = this.source.getReferenceBases(sequence, true);
            refSeqName = sequence.getSequenceName();
        }
        int start = 0;
        int stop = 0;
        for (SAMRecord r : this.samRecords) {
            if (r.getAlignmentStart() == 0) continue;
            if (start == 0) {
                start = r.getAlignmentStart();
            }
            start = Math.min(r.getAlignmentStart(), start);
            stop = Math.max(r.getAlignmentEnd(), stop);
        }
        ReferenceTracks tracks = null;
        if (this.preservation != null && this.preservation.areReferenceTracksRequired()) {
            tracks = new ReferenceTracks(this.refSeqIndex, refSeqName, refs);
            tracks.ensureRange(start, stop - start + 1);
            CRAMFileWriter.updateTracks(this.samRecords, tracks);
        }
        ArrayList<CramCompressionRecord> cramRecords = new ArrayList<CramCompressionRecord>(this.samRecords.size());
        Sam2CramRecordFactory sam2CramRecordFactory = new Sam2CramRecordFactory(refs, this.samFileHeader, cramVersion);
        sam2CramRecordFactory.preserveReadNames = this.preserveReadNames;
        sam2CramRecordFactory.captureAllTags = this.captureAllTags;
        sam2CramRecordFactory.captureTags.addAll(this.captureTags);
        sam2CramRecordFactory.ignoreTags.addAll(this.ignoreTags);
        this.containerFactory.setPreserveReadNames(this.preserveReadNames);
        int index = 0;
        int prevAlStart = start;
        for (SAMRecord samRecord : this.samRecords) {
            CramCompressionRecord cramRecord = sam2CramRecordFactory.createCramRecord(samRecord);
            cramRecord.index = ++index;
            cramRecord.alignmentDelta = samRecord.getAlignmentStart() - prevAlStart;
            cramRecord.alignmentStart = samRecord.getAlignmentStart();
            prevAlStart = samRecord.getAlignmentStart();
            cramRecords.add(cramRecord);
            if (this.preservation != null) {
                this.preservation.addQualityScores(samRecord, cramRecord, tracks);
                continue;
            }
            if (cramRecord.qualityScores == SAMRecord.NULL_QUALS) continue;
            cramRecord.setForcePreserveQualityScores(true);
        }
        if (sam2CramRecordFactory.getBaseCount() < 3L * sam2CramRecordFactory.getFeatureCount()) {
            log.warn("Abnormally high number of mismatches, possibly wrong reference.");
        }
        if (this.samFileHeader.getSortOrder() == SAMFileHeader.SortOrder.coordinate) {
            TreeMap primaryMateMap = new TreeMap();
            TreeMap<String, CramCompressionRecord> secondaryMateMap = new TreeMap<String, CramCompressionRecord>();
            for (CramCompressionRecord r : cramRecords) {
                if (!r.isMultiFragment()) {
                    r.setDetached(true);
                    r.setHasMateDownStream(false);
                    r.recordsToNextFragment = -1;
                    r.next = null;
                    r.previous = null;
                    continue;
                }
                String name = r.readName;
                TreeMap<String, CramCompressionRecord> mateMap = r.isSecondaryAlignment() ? secondaryMateMap : primaryMateMap;
                CramCompressionRecord mate = (CramCompressionRecord)mateMap.get(name);
                if (mate == null) {
                    mateMap.put(name, r);
                    continue;
                }
                CramCompressionRecord prev = mate;
                while (prev.next != null) {
                    prev = prev.next;
                }
                prev.recordsToNextFragment = r.index - prev.index - 1;
                prev.next = r;
                r.previous = prev;
                r.previous.setHasMateDownStream(true);
                r.setHasMateDownStream(false);
                r.setDetached(false);
                r.previous.setDetached(false);
            }
            for (CramCompressionRecord cramRecord : cramRecords) {
                if (cramRecord.next == null || cramRecord.previous != null) continue;
                CramCompressionRecord last = cramRecord;
                while (last.next != null) {
                    last = last.next;
                }
                if (cramRecord.isFirstSegment() && last.isLastSegment()) {
                    int templateLength = CramNormalizer.computeInsertSize(cramRecord, last);
                    if (cramRecord.templateSize != templateLength) continue;
                    last = cramRecord.next;
                    while (last.next != null && last.templateSize == -templateLength) {
                        last = last.next;
                    }
                    if (last.templateSize == -templateLength) continue;
                    CRAMFileWriter.detach(cramRecord);
                    continue;
                }
                CRAMFileWriter.detach(cramRecord);
            }
            for (CramCompressionRecord cramRecord : primaryMateMap.values()) {
                if (cramRecord.next != null) continue;
                cramRecord.setDetached(true);
                cramRecord.setHasMateDownStream(false);
                cramRecord.recordsToNextFragment = -1;
                cramRecord.next = null;
                cramRecord.previous = null;
            }
            for (CramCompressionRecord cramRecord : secondaryMateMap.values()) {
                if (cramRecord.next != null) continue;
                cramRecord.setDetached(true);
                cramRecord.setHasMateDownStream(false);
                cramRecord.recordsToNextFragment = -1;
                cramRecord.next = null;
                cramRecord.previous = null;
            }
        } else {
            for (CramCompressionRecord cramRecord : cramRecords) {
                cramRecord.setDetached(true);
            }
        }
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        if (assertsEnabled) {
            Cram2SamRecordFactory f = new Cram2SamRecordFactory(this.samFileHeader);
            for (int i = 0; i < this.samRecords.size(); ++i) {
                SAMRecord restoredSamRecord = f.create((CramCompressionRecord)cramRecords.get(i));
                assert (restoredSamRecord.getAlignmentStart() == this.samRecords.get(i).getAlignmentStart());
                assert (restoredSamRecord.getReferenceName().equals(this.samRecords.get(i).getReferenceName()));
                assert (restoredSamRecord.getReadString().equals(this.samRecords.get(i).getReadString()));
                assert (restoredSamRecord.getBaseQualityString().equals(this.samRecords.get(i).getBaseQualityString()));
            }
        }
        Container container = this.containerFactory.buildContainer(cramRecords);
        for (Slice slice : container.slices) {
            slice.setRefMD5(refs);
        }
        container.offset = this.offset;
        this.offset += (long)ContainerIO.writeContainer(cramVersion, container, this.outputStream);
        if (this.indexer != null) {
            for (Slice slice : container.slices) {
                this.indexer.processAlignment(slice);
            }
        }
        this.samRecords.clear();
    }

    private static void detach(CramCompressionRecord cramRecord) {
        do {
            cramRecord.setDetached(true);
            cramRecord.setHasMateDownStream(false);
            cramRecord.recordsToNextFragment = -1;
        } while ((cramRecord = cramRecord.next) != null);
    }

    @Override
    protected void writeAlignment(SAMRecord alignment) {
        if (this.shouldFlushContainer(alignment)) {
            try {
                this.flushContainer();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.updateReferenceContext(alignment.getReferenceIndex());
        this.samRecords.add(alignment);
    }

    private void updateReferenceContext(int samRecordReferenceIndex) {
        if (this.refSeqIndex == -2) {
            this.refSeqIndex = samRecordReferenceIndex;
        } else if (this.refSeqIndex != samRecordReferenceIndex) {
            this.refSeqIndex = samRecordReferenceIndex;
        }
    }

    @Override
    protected void writeHeader(String textHeader) {
        SAMFileHeader header = new SAMTextHeaderCodec().decode(new StringLineReader(textHeader), this.fileName != null ? this.fileName : null);
        this.containerFactory = new ContainerFactory(header, this.recordsPerSlice);
        CramHeader cramHeader = new CramHeader(cramVersion, this.fileName, header);
        try {
            this.offset = CramIO.writeCramHeader(cramHeader, this.outputStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void finish() {
        try {
            if (!this.samRecords.isEmpty()) {
                this.flushContainer();
            }
            CramIO.issueEOF(cramVersion, this.outputStream);
            this.outputStream.flush();
            if (this.indexer != null) {
                this.indexer.finish();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getFilename() {
        return this.fileName;
    }

    public boolean isPreserveReadNames() {
        return this.preserveReadNames;
    }

    public void setPreserveReadNames(boolean preserveReadNames) {
        this.preserveReadNames = preserveReadNames;
    }

    public List<PreservationPolicy> getPreservationPolicies() {
        if (this.preservation == null) {
            this.preservation = new QualityScorePreservation("*8");
        }
        return this.preservation.getPreservationPolicies();
    }

    public boolean isCaptureAllTags() {
        return this.captureAllTags;
    }

    public void setCaptureAllTags(boolean captureAllTags) {
        this.captureAllTags = captureAllTags;
    }

    public Set<String> getCaptureTags() {
        return this.captureTags;
    }

    public void setCaptureTags(Set<String> captureTags) {
        this.captureTags = captureTags;
    }

    public Set<String> getIgnoreTags() {
        return this.ignoreTags;
    }

    public void setIgnoreTags(Set<String> ignoreTags) {
        this.ignoreTags = ignoreTags;
    }
}

