/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.Histogram;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import picard.PicardException;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceStates;

public class GenotypeConcordanceCounts {
    static final GenotypeConcordanceStates.TruthState[] HOM_REF_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HOM_REF};
    static final GenotypeConcordanceStates.TruthState[] HET_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HET_REF_VAR1, GenotypeConcordanceStates.TruthState.HET_VAR1_VAR2};
    static final GenotypeConcordanceStates.TruthState[] HOM_VAR_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HOM_VAR1};
    static final GenotypeConcordanceStates.TruthState[] VAR_TRUTH_STATES = new GenotypeConcordanceStates.TruthState[]{GenotypeConcordanceStates.TruthState.HET_REF_VAR1, GenotypeConcordanceStates.TruthState.HET_VAR1_VAR2, GenotypeConcordanceStates.TruthState.HOM_VAR1, GenotypeConcordanceStates.TruthState.HOM_REF, GenotypeConcordanceStates.TruthState.MISSING};
    static final GenotypeConcordanceStates.CallState[] HOM_REF_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HOM_REF};
    static final GenotypeConcordanceStates.CallState[] HET_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HET_REF_VAR1, GenotypeConcordanceStates.CallState.HET_REF_VAR2, GenotypeConcordanceStates.CallState.HET_REF_VAR3, GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, GenotypeConcordanceStates.CallState.HET_VAR3_VAR4};
    static final GenotypeConcordanceStates.CallState[] HOM_VAR_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HOM_VAR1, GenotypeConcordanceStates.CallState.HOM_VAR2, GenotypeConcordanceStates.CallState.HOM_VAR3};
    static final GenotypeConcordanceStates.CallState[] VAR_CALL_STATES = new GenotypeConcordanceStates.CallState[]{GenotypeConcordanceStates.CallState.HET_REF_VAR1, GenotypeConcordanceStates.CallState.HET_REF_VAR2, GenotypeConcordanceStates.CallState.HET_REF_VAR3, GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, GenotypeConcordanceStates.CallState.HET_VAR3_VAR4, GenotypeConcordanceStates.CallState.HOM_VAR1, GenotypeConcordanceStates.CallState.HOM_VAR2, GenotypeConcordanceStates.CallState.HOM_VAR3};
    private final Histogram<GenotypeConcordanceStates.TruthAndCallStates> counter = new Histogram();

    public void increment(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates) {
        this.counter.increment(truthAndCallStates);
    }

    public void increment(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates, double count) {
        this.counter.increment(truthAndCallStates, count);
    }

    public double getCounterSize() {
        return this.counter.getCount();
    }

    public void validateCountsAgainstScheme(GenotypeConcordanceScheme scheme) {
        Set<GenotypeConcordanceStates.ContingencyState> naContingencyStates = this.getContingencyStateSet(GenotypeConcordanceScheme.NA);
        for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                Set<GenotypeConcordanceStates.ContingencyState> contingencyStates;
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                if (0L >= this.getCount(truthAndCallStates) || !(contingencyStates = this.getContingencyStateSet(scheme.getConcordanceStateArray(truthAndCallStates))).containsAll(naContingencyStates)) continue;
                throw new PicardException(String.format("Found counts for an illegal set of states: [%s, %s]", truthState.name(), callState.name()));
            }
        }
    }

    private Set<GenotypeConcordanceStates.ContingencyState> getContingencyStateSet(GenotypeConcordanceStates.ContingencyState[] contingencyStateArray) {
        HashSet<GenotypeConcordanceStates.ContingencyState> contingencyStateSet = new HashSet<GenotypeConcordanceStates.ContingencyState>();
        Collections.addAll(contingencyStateSet, contingencyStateArray);
        return contingencyStateSet;
    }

    private double calculateGenotypeConcordanceUtil(GenotypeConcordanceScheme scheme, boolean missingSitesFlag, boolean includeHomRef) {
        double numerator = 0.0;
        double denominator = 0.0;
        scheme.validateScheme();
        GenotypeConcordanceStates.TruthState[] allTruthStates = GenotypeConcordanceStates.TruthState.values();
        GenotypeConcordanceStates.CallState[] allCallStates = GenotypeConcordanceStates.CallState.values();
        for (GenotypeConcordanceStates.TruthState truthState : allTruthStates) {
            for (GenotypeConcordanceStates.CallState callState : allCallStates) {
                if (!missingSitesFlag && this.isMissing(truthState, callState) || !includeHomRef && !this.isVar(truthState, callState)) continue;
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long count = this.getCount(truthAndCallStates);
                if (truthState.getCode() == callState.getCode()) {
                    numerator += (double)count;
                }
                denominator += (double)count;
            }
        }
        return denominator > 0.0 ? numerator / denominator : Double.NaN;
    }

    public double calculateGenotypeConcordance(GenotypeConcordanceScheme scheme, boolean missingSitesFlag) {
        return this.calculateGenotypeConcordanceUtil(scheme, missingSitesFlag, true);
    }

    public double calculateNonRefGenotypeConcordance(GenotypeConcordanceScheme scheme, boolean missingSitesFlag) {
        return this.calculateGenotypeConcordanceUtil(scheme, missingSitesFlag, false);
    }

    public double getSensitivity(GenotypeConcordanceScheme scheme, GenotypeConcordanceStates.TruthState[] truthStateArray) {
        double numerator = 0.0;
        double denominator = 0.0;
        scheme.validateScheme();
        for (GenotypeConcordanceStates.TruthState truthState : truthStateArray) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long count = this.getCount(truthAndCallStates);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : scheme.getConcordanceStateArray(truthAndCallStates)) {
                    if (GenotypeConcordanceStates.ContingencyState.TP == contingencyState) {
                        numerator += (double)count;
                        denominator += (double)count;
                        continue;
                    }
                    if (GenotypeConcordanceStates.ContingencyState.FN != contingencyState) continue;
                    denominator += (double)count;
                }
            }
        }
        return numerator / denominator;
    }

    public double Ppv(GenotypeConcordanceScheme scheme, GenotypeConcordanceStates.CallState[] callStateList) {
        double numerator = 0.0;
        double denominator = 0.0;
        scheme.validateScheme();
        for (GenotypeConcordanceStates.CallState callState : callStateList) {
            for (GenotypeConcordanceStates.TruthState truthState : GenotypeConcordanceStates.TruthState.values()) {
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long count = this.getCount(truthAndCallStates);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : scheme.getConcordanceStateArray(truthAndCallStates)) {
                    if (GenotypeConcordanceStates.ContingencyState.TP == contingencyState) {
                        numerator += (double)count;
                        denominator += (double)count;
                        continue;
                    }
                    if (GenotypeConcordanceStates.ContingencyState.FP != contingencyState) continue;
                    denominator += (double)count;
                }
            }
        }
        return numerator / denominator;
    }

    public double getSpecificity(GenotypeConcordanceScheme scheme, GenotypeConcordanceStates.TruthState[] truthStateArray) {
        double numerator = 0.0;
        double denominator = 0.0;
        scheme.validateScheme();
        for (GenotypeConcordanceStates.TruthState truthState : truthStateArray) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState);
                long count = this.getCount(truthAndCallStates);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : scheme.getConcordanceStateArray(truthAndCallStates)) {
                    if (GenotypeConcordanceStates.ContingencyState.TN == contingencyState) {
                        numerator += (double)count;
                        denominator += (double)count;
                        continue;
                    }
                    if (GenotypeConcordanceStates.ContingencyState.FP != contingencyState) continue;
                    denominator += (double)count;
                }
            }
        }
        return numerator / denominator;
    }

    public long getCount(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        return this.getCount(new GenotypeConcordanceStates.TruthAndCallStates(truthState, callState));
    }

    public long getCount(GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates) {
        Histogram.Bin bin = (Histogram.Bin)this.counter.get(truthAndCallStates);
        return bin == null ? 0L : (long)bin.getValue();
    }

    public boolean isVar(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        List<GenotypeConcordanceStates.TruthState> listOfTruthStates = Arrays.asList(GenotypeConcordanceStates.TruthState.HOM_VAR1, GenotypeConcordanceStates.TruthState.HET_REF_VAR1, GenotypeConcordanceStates.TruthState.HET_VAR1_VAR2);
        List<GenotypeConcordanceStates.CallState> listOfCallStates = Arrays.asList(GenotypeConcordanceStates.CallState.HET_REF_VAR1, GenotypeConcordanceStates.CallState.HET_REF_VAR2, GenotypeConcordanceStates.CallState.HET_REF_VAR3, GenotypeConcordanceStates.CallState.HET_VAR1_VAR2, GenotypeConcordanceStates.CallState.HET_VAR1_VAR3, GenotypeConcordanceStates.CallState.HET_VAR3_VAR4, GenotypeConcordanceStates.CallState.HOM_VAR1, GenotypeConcordanceStates.CallState.HOM_VAR2, GenotypeConcordanceStates.CallState.HOM_VAR3);
        return listOfTruthStates.contains((Object)truthState) || listOfCallStates.contains((Object)callState);
    }

    public boolean isMissing(GenotypeConcordanceStates.TruthState truthState, GenotypeConcordanceStates.CallState callState) {
        return truthState == GenotypeConcordanceStates.TruthState.MISSING || callState == GenotypeConcordanceStates.CallState.MISSING;
    }

    public long getSum(Set<GenotypeConcordanceStates.TruthState> truthStateSet, Set<GenotypeConcordanceStates.CallState> callStateSet) {
        long count = 0L;
        for (GenotypeConcordanceStates.TruthState truthState : truthStateSet) {
            for (GenotypeConcordanceStates.CallState callState : callStateSet) {
                count += this.getCount(truthState, callState);
            }
        }
        return count;
    }

    public long getSum() {
        return this.getSum(new HashSet<GenotypeConcordanceStates.TruthState>(Arrays.asList(GenotypeConcordanceStates.TruthState.values())), new HashSet<GenotypeConcordanceStates.CallState>(Arrays.asList(GenotypeConcordanceStates.CallState.values())));
    }

    public Map<GenotypeConcordanceStates.ContingencyState, Long> getContingencyStateCounts(GenotypeConcordanceScheme scheme) {
        scheme.validateScheme();
        HashMap<GenotypeConcordanceStates.ContingencyState, Long> counts = new HashMap<GenotypeConcordanceStates.ContingencyState, Long>();
        for (GenotypeConcordanceStates.ContingencyState contingencyState : GenotypeConcordanceStates.ContingencyState.values()) {
            counts.put(contingencyState, 0L);
        }
        for (Enum enum_ : GenotypeConcordanceStates.TruthState.values()) {
            for (GenotypeConcordanceStates.CallState callState : GenotypeConcordanceStates.CallState.values()) {
                GenotypeConcordanceStates.ContingencyState[] contingencyStateArray;
                GenotypeConcordanceStates.TruthAndCallStates truthAndCallStates = new GenotypeConcordanceStates.TruthAndCallStates((GenotypeConcordanceStates.TruthState)enum_, callState);
                for (GenotypeConcordanceStates.ContingencyState contingencyState : contingencyStateArray = scheme.getConcordanceStateArray(truthAndCallStates)) {
                    long newCount = (Long)counts.get((Object)contingencyState) + this.getCount(truthAndCallStates);
                    counts.put(contingencyState, newCount);
                }
            }
        }
        return counts;
    }
}

