/*
 * Decompiled with CFR 0.152.
 */
package picard.util;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import htsjdk.samtools.metrics.MetricBase;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.TreeMap;

public class MetricsDoclet {
    public static boolean start(RootDoc root) {
        TreeMap<String, ClassDoc> metricsClasses = new TreeMap<String, ClassDoc>();
        for (ClassDoc doc : root.classes()) {
            if (!MetricsDoclet.isMetricsClass(doc)) continue;
            System.out.println("Processing " + doc.qualifiedTypeName());
            metricsClasses.put(doc.typeName(), doc);
        }
        PrintStream out = MetricsDoclet.getOutput(root);
        if (out == null) {
            return false;
        }
        out.println("<h2>Picard Metrics Definitions</h2>");
        out.println("<section>");
        out.println("<p> Click on a metric to see a description of its fields.</p>");
        out.println("<ol>");
        for (ClassDoc doc : metricsClasses.values()) {
            out.println("<li><a href=\"#" + doc.name() + "\">" + doc.name() + "</a>: " + MetricsDoclet.firstSentence((Doc)doc) + "</li>");
        }
        out.println("</ol>");
        out.println("</section>");
        for (ClassDoc doc : metricsClasses.values()) {
            out.println("<a id=\"" + doc.name() + "\"></a>");
            out.println("<h2>" + doc.name() + "</h2>");
            out.println("<section>");
            out.println("<p>" + doc.commentText() + "</p>");
            out.println("<table>");
            out.println("<tr><th>Field</th><th>Description</th></tr>");
            for (FieldDoc field : doc.fields()) {
                if (!field.isPublic() || field.isStatic()) continue;
                out.append("<tr>");
                out.append("<td>" + field.name() + "</td>");
                out.append("<td>" + field.commentText() + "</td>");
                out.append("</tr>");
            }
            out.println("</table>");
            out.println("</section>");
        }
        out.close();
        return true;
    }

    protected static boolean isMetricsClass(ClassDoc doc) {
        String metricBaseFqn = MetricBase.class.getName();
        if (!doc.isClass()) {
            return false;
        }
        if (doc.qualifiedTypeName().contains("personal")) {
            return false;
        }
        do {
            if ((doc = doc.superclass()) == null || !metricBaseFqn.equals(doc.qualifiedTypeName())) continue;
            return true;
        } while (doc != null);
        return false;
    }

    protected static PrintStream getOutput(RootDoc root) {
        for (String[] arg : root.options()) {
            if (!arg[0].equals("-f") || arg.length != 2) continue;
            try {
                return new PrintStream(new File(arg[1]));
            }
            catch (FileNotFoundException fnfe) {
                root.printError("Could not open destination file: " + arg[1]);
                fnfe.printStackTrace();
                return null;
            }
        }
        root.printError("Destination file parameter -f not supplied.");
        return null;
    }

    public static int optionLength(String option) {
        if (option.equals("-f")) {
            return 2;
        }
        return 0;
    }

    protected static String firstSentence(Doc doc) {
        Tag[] tags = doc.firstSentenceTags();
        StringBuilder builder = new StringBuilder(128);
        for (Tag tag : tags) {
            builder.append(tag.text());
        }
        return builder.toString();
    }
}

