/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.SAMUtils;
import htsjdk.samtools.SamPairUtil;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SortingCollection;
import java.io.File;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;
import picard.sam.AbstractAlignmentMerger;

@CommandLineProgramProperties(usage="Reverts the original base qualities and adds the mate cigar tag to read-group BAMs.", usageShort="Reverts the original base qualities and adds the mate cigar tag to read-group BAMs", programGroup=SamOrBam.class)
public class RevertOriginalBaseQualitiesAndAddMateCigar
extends CommandLineProgram {
    @Option(shortName="I", doc="The input SAM/BAM file to revert the state of.")
    public File INPUT;
    @Option(shortName="O", doc="The output SAM/BAM file to create.")
    public File OUTPUT;
    @Option(shortName="SO", doc="The sort order to create the reverted output file with.By default, the sort order will be the same as the input.", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = null;
    @Option(shortName="OQ", doc="True to restore original qualities from the OQ field to the QUAL field if available.")
    public boolean RESTORE_ORIGINAL_QUALITIES = true;
    @Option(doc="The maximum number of records to examine to determine if we can exit early and not output, given that there are a no original base qualities (if we are to restore) and mate cigars exist. Set to 0 to never skip the file.")
    public int MAX_RECORDS_TO_EXAMINE = 10000;
    private static final Log log = Log.getInstance(RevertOriginalBaseQualitiesAndAddMateCigar.class);

    public RevertOriginalBaseQualitiesAndAddMateCigar() {
        this.CREATE_INDEX = true;
        this.CREATE_MD5_FILE = true;
    }

    public static void main(String[] args) {
        new RevertOriginalBaseQualitiesAndAddMateCigar().instanceMainWithExit(args);
    }

    @Override
    public int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        boolean foundPairedMappedReads = false;
        CanSkipSamFile skipSamFile = RevertOriginalBaseQualitiesAndAddMateCigar.canSkipSAMFile(this.INPUT, this.MAX_RECORDS_TO_EXAMINE, this.RESTORE_ORIGINAL_QUALITIES, this.REFERENCE_SEQUENCE);
        log.info(skipSamFile.getMessage(this.MAX_RECORDS_TO_EXAMINE));
        if (skipSamFile.canSkip()) {
            return 0;
        }
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).enable(SamReaderFactory.Option.EAGERLY_DECODE).open(this.INPUT);
        SAMFileHeader inHeader = in.getFileHeader();
        SAMFileHeader outHeader = inHeader.clone();
        if (null == this.SORT_ORDER) {
            this.SORT_ORDER = inHeader.getSortOrder();
        }
        outHeader.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory.setDefaultCreateIndexWhileWriting(this.CREATE_INDEX);
        SAMFileWriterFactory.setDefaultCreateMd5File(this.CREATE_MD5_FILE);
        SAMFileWriter out = new SAMFileWriterFactory().makeSAMOrBAMWriter(outHeader, false, this.OUTPUT);
        SortingCollection<SAMRecord> sorter = SortingCollection.newInstance(SAMRecord.class, new BAMRecordCodec(outHeader), new SAMRecordQueryNameComparator(), this.MAX_RECORDS_IN_RAM);
        ProgressLogger revertingProgress = new ProgressLogger(log, 1000000, " reverted OQs");
        int numOriginalQualitiesRestored = 0;
        for (SAMRecord record : in) {
            AbstractAlignmentMerger.createNewCigarsIfMapsOffEndOfReference(record);
            if (this.RESTORE_ORIGINAL_QUALITIES && null != record.getOriginalBaseQualities()) {
                record.setBaseQualities(record.getOriginalBaseQualities());
                record.setOriginalBaseQualities(null);
                ++numOriginalQualitiesRestored;
            }
            if (!foundPairedMappedReads && record.getReadPairedFlag() && !record.getReadUnmappedFlag()) {
                foundPairedMappedReads = true;
            }
            revertingProgress.record(record);
            sorter.add(record);
        }
        CloserUtil.close(in);
        log.info("Reverted the original base qualities for " + numOriginalQualitiesRestored + " records");
        SamPairUtil.SetMateInfoIterator sorterIterator = new SamPairUtil.SetMateInfoIterator(sorter.iterator(), true);
        ProgressLogger sorterProgress = new ProgressLogger(log, 1000000, " mate cigars added");
        while (sorterIterator.hasNext()) {
            SAMRecord record = sorterIterator.next();
            out.addAlignment(record);
            sorterProgress.record(record);
        }
        sorterIterator.close();
        CloserUtil.close(out);
        log.info("Updated " + sorterIterator.getNumMateCigarsAdded() + " records with mate cigar");
        if (!foundPairedMappedReads) {
            log.info("Did not find any paired mapped reads.");
        }
        return 0;
    }

    public static CanSkipSamFile canSkipSAMFile(File inputFile, int maxRecordsToExamine, boolean revertOriginalBaseQualities, File referenceFasta) {
        SamReader in = SamReaderFactory.makeDefault().referenceSequence(referenceFasta).enable(SamReaderFactory.Option.EAGERLY_DECODE).open(inputFile);
        SAMRecordIterator iterator = in.iterator();
        CanSkipSamFile returnType = CanSkipSamFile.FOUND_NO_EVIDENCE;
        for (int numRecordsExamined = 0; iterator.hasNext() && numRecordsExamined < maxRecordsToExamine; ++numRecordsExamined) {
            SAMRecord record = (SAMRecord)iterator.next();
            if (revertOriginalBaseQualities && null != record.getOriginalBaseQualities()) {
                returnType = CanSkipSamFile.CANNOT_SKIP_FOUND_OQ;
                break;
            }
            if (!record.getReadPairedFlag() || record.getMateUnmappedFlag()) continue;
            if (null == SAMUtils.getMateCigar(record)) {
                returnType = CanSkipSamFile.CANNOT_SKIP_FOUND_NO_MC;
                break;
            }
            returnType = CanSkipSamFile.CAN_SKIP;
            break;
        }
        if (!iterator.hasNext() && CanSkipSamFile.FOUND_NO_EVIDENCE == returnType) {
            returnType = CanSkipSamFile.CAN_SKIP;
        }
        CloserUtil.close(in);
        return returnType;
    }

    public static enum CanSkipSamFile {
        CAN_SKIP("Can skip the BAM file", true),
        CANNOT_SKIP_FOUND_OQ("Cannot skip the BAM as we found a record with an OQ", false),
        CANNOT_SKIP_FOUND_NO_MC("Cannot skip the BAM as we found a mate with no mate cigar tag", false),
        FOUND_NO_EVIDENCE("Found no evidence of OQ or mate with no mate cigar in the first %d records.  Will continue...", false);

        private final String format;
        private final boolean skip;

        private CanSkipSamFile(String format, boolean skip) {
            this.format = format;
            this.skip = skip;
        }

        public String getMessage(int maxRecordsToExamine) {
            return String.format(this.format, maxRecordsToExamine);
        }

        public boolean canSkip() {
            return this.skip;
        }
    }
}

