/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.BamFileIoUtils;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Replace the SAMFileHeader in a SAM file with the given header. Validation is minimal.  It is up to the user to ensure that all the elements referred to in the SAMRecords are present in the new header.  Sort order of the two input files must be the same.", usageShort="Replace the SAMFileHeader in a SAM file with the given header", programGroup=SamOrBam.class)
public class ReplaceSamHeader
extends CommandLineProgram {
    @Option(doc="SAM file from which SAMRecords will be read.", shortName="I")
    public File INPUT;
    @Option(doc="SAM file from which SAMFileHeader will be read.")
    public File HEADER;
    @Option(doc="SAMFileHeader from HEADER file will be written to this file, followed by SAMRecords from INPUT file", shortName="O")
    public File OUTPUT;

    public static void main(String[] argv) {
        new ReplaceSamHeader().instanceMainWithExit(argv);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsReadable(this.HEADER);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        SAMFileHeader replacementHeader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.HEADER);
        if (BamFileIoUtils.isBamFile(this.INPUT)) {
            this.blockCopyReheader(replacementHeader);
        } else {
            this.standardReheader(replacementHeader);
        }
        return 0;
    }

    private void standardReheader(SAMFileHeader replacementHeader) {
        SamReader recordReader = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).validationStringency(ValidationStringency.SILENT).open(this.INPUT);
        if (replacementHeader.getSortOrder() != recordReader.getFileHeader().getSortOrder()) {
            throw new PicardException("Sort orders of INPUT (" + recordReader.getFileHeader().getSortOrder().name() + ") and HEADER (" + replacementHeader.getSortOrder().name() + ") do not agree.");
        }
        SAMFileWriter writer = new SAMFileWriterFactory().makeSAMOrBAMWriter(replacementHeader, true, this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(Log.getInstance(ReplaceSamHeader.class));
        for (SAMRecord rec : recordReader) {
            rec.setHeader(replacementHeader);
            writer.addAlignment(rec);
            progress.record(rec);
        }
        writer.close();
        CloserUtil.close(recordReader);
    }

    private void blockCopyReheader(SAMFileHeader replacementHeader) {
        BamFileIoUtils.reheaderBamFile(replacementHeader, this.INPUT, this.OUTPUT, this.CREATE_MD5_FILE, this.CREATE_INDEX);
    }
}

