/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.samtools.util.IOUtil;
import java.io.File;
import java.io.IOException;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.SamOrBam;

@CommandLineProgramProperties(usage="Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise", usageShort="Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise", programGroup=SamOrBam.class)
public class CheckTerminatorBlock
extends CommandLineProgram {
    static final String USAGE = "Asserts the provided gzip file's (e.g., BAM) last block is well-formed; RC 100 otherwise";
    @Option(shortName="I", doc="The block compressed file to check.")
    public File INPUT;

    public static void main(String[] args) {
        new CheckTerminatorBlock().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        try {
            BlockCompressedInputStream.FileTermination term = BlockCompressedInputStream.checkTermination(this.INPUT);
            System.err.println(term.name());
            if (term == BlockCompressedInputStream.FileTermination.DEFECTIVE) {
                return 100;
            }
            return 0;
        }
        catch (IOException ioe) {
            throw new PicardException("Exception reading terminator block of file: " + this.INPUT.getAbsolutePath());
        }
    }
}

