/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina.parser;

import htsjdk.samtools.util.StringUtil;
import picard.PicardException;
import picard.illumina.parser.Range;
import picard.illumina.parser.ReadDescriptor;
import picard.illumina.parser.ReadStructure;

public class OutputMapping {
    private final TwoDIndex[] cycleToOutputIndex;
    private final ReadStructure.Substructure outputSubstructure;
    private final ReadStructure outputReadStructure;

    public OutputMapping(ReadStructure readStructure) {
        this.outputSubstructure = readStructure.nonSkips;
        this.cycleToOutputIndex = this.makeCycleToOutputIndexArray(readStructure);
        this.outputReadStructure = this.outputSubstructure.toReadStructure();
    }

    public int numOutputReads() {
        return this.outputSubstructure.length();
    }

    public int[] getOutputCycles() {
        return this.outputSubstructure.getCycles();
    }

    public int[] getOutputReadLengths() {
        return this.outputSubstructure.getDescriptorLengths();
    }

    public int getTotalOutputCycles() {
        return this.outputSubstructure.getTotalCycles();
    }

    public Range[] getCycleIndexRanges() {
        return this.outputSubstructure.getCycleIndexRanges();
    }

    public Iterable<ReadDescriptor> getOutputDescriptors() {
        return this.outputSubstructure;
    }

    public ReadStructure getOutputReadStructure() {
        return this.outputReadStructure;
    }

    public TwoDIndex getOutputIndexForCycle(int cycle) {
        return this.cycleToOutputIndex[cycle];
    }

    private TwoDIndex[] makeCycleToOutputIndexArray(ReadStructure readStructure) {
        int totalCycles = readStructure.totalCycles;
        TwoDIndex[] cycleToOutputIndex = new TwoDIndex[totalCycles + 1];
        int[] outputCycles = this.getOutputCycles();
        int[] outputLengths = this.getOutputReadLengths();
        int outputCycleIndex = 0;
        int arrIndex = 0;
        int elementIndex = 0;
        for (int i = 1; i <= totalCycles && outputCycleIndex < outputCycles.length; ++i) {
            if (outputCycles[outputCycleIndex] != i) continue;
            if (elementIndex >= outputLengths[arrIndex]) {
                elementIndex = 0;
                ++arrIndex;
            }
            cycleToOutputIndex[i] = new TwoDIndex(arrIndex, elementIndex);
            ++elementIndex;
            ++outputCycleIndex;
        }
        if (outputCycleIndex != outputCycles.length) {
            throw new PicardException("Error in read structure outputCycles (" + StringUtil.intValuesToString(outputCycles) + ") and total cycles (" + totalCycles + ") OutputCycleIndex(" + outputCycleIndex + ")");
        }
        return cycleToOutputIndex;
    }

    static class TwoDIndex {
        public final int majorIndex;
        public final int minorIndex;

        public TwoDIndex(int majorIndex, int minorIndex) {
            this.majorIndex = majorIndex;
            this.minorIndex = minorIndex;
        }

        public String toString() {
            return "TwoDIndex(majorIndex == " + this.majorIndex + ", minorIndex == " + this.minorIndex + ")";
        }

        public boolean equals(Object thatObj) {
            if (thatObj == null || !(thatObj instanceof TwoDIndex)) {
                return false;
            }
            TwoDIndex that = (TwoDIndex)thatObj;
            return this.majorIndex == that.majorIndex && this.minorIndex == that.minorIndex;
        }
    }
}

