/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.PeekableIterator;
import htsjdk.samtools.util.ProgressLogger;
import java.io.File;
import java.util.List;
import picard.analysis.CollectWgsMetrics;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.CommandLineProgramProperties;
import picard.cmdline.Option;
import picard.cmdline.programgroups.Metrics;
import picard.util.QuerySortedReadPairIteratorUtil;

@CommandLineProgramProperties(usage="Computes a number of metrics that are useful for evaluating coverage and performance of sequencing experiments.", usageShort="Writes sequencing-related metrics for a SAM or BAM file", programGroup=Metrics.class)
public class CollectWgsMetricsFromQuerySorted
extends CommandLineProgram {
    @Option(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Option(shortName="O", doc="Output metrics file.")
    public File OUTPUT;
    @Option(shortName="MQ", doc="Minimum mapping quality for a read to contribute coverage.", overridable=true)
    public int MINIMUM_MAPPING_QUALITY = 20;
    @Option(shortName="Q", doc="Minimum base quality for a base to contribute coverage.", overridable=true)
    public int MINIMUM_BASE_QUALITY = 20;
    private final Log log = Log.getInstance(CollectWgsMetricsFromQuerySorted.class);

    public static void main(String[] args) {
        new CollectWgsMetricsFromQuerySorted().instanceMainWithExit(args);
    }

    @Override
    protected int doWork() {
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(this.log, 50000000, "Processed", "read pairs");
        SamReader reader = SamReaderFactory.makeDefault().open(this.INPUT);
        PeekableIterator<SAMRecord> iterator = new PeekableIterator<SAMRecord>(reader.iterator());
        QuerySortedSeqMetrics metrics = new QuerySortedSeqMetrics();
        long basesExcludedByDupes = 0L;
        long basesExcludedByMapq = 0L;
        long basesExcludedByPairing = 0L;
        long basesExcludedByBaseq = 0L;
        long basesExcludedByOverlap = 0L;
        double insertSizeSum = 0.0;
        QuerySortedReadPairIteratorUtil.ReadPair pairToAnalyze = QuerySortedReadPairIteratorUtil.getNextReadPair(iterator);
        while (pairToAnalyze != null) {
            boolean isProperPair = pairToAnalyze.read2 != null;
            int read1bases = pairToAnalyze.read1.getReadLength();
            int read2bases = isProperPair ? pairToAnalyze.read2.getReadLength() : 0;
            int totalReadBases = read1bases + read2bases;
            metrics.TOTAL_BASES += (long)totalReadBases;
            if (isProperPair) {
                ++metrics.TOTAL_READ_PAIRS;
            }
            if (!isProperPair || pairToAnalyze.read1.getMateUnmappedFlag() || pairToAnalyze.read2.getMateUnmappedFlag()) {
                basesExcludedByPairing += (long)totalReadBases;
            } else if (pairToAnalyze.read1.getDuplicateReadFlag()) {
                ++metrics.TOTAL_DUPE_PAIRS;
                basesExcludedByDupes += (long)totalReadBases;
            } else {
                BaseExclusionHelper read1exclusions = this.determineBaseExclusions(pairToAnalyze.read1);
                BaseExclusionHelper read2exclusions = this.determineBaseExclusions(pairToAnalyze.read2);
                basesExcludedByMapq += (long)(read1exclusions.basesExcludedByMapq + read2exclusions.basesExcludedByMapq);
                basesExcludedByBaseq += (long)(read1exclusions.lowBQcount + read2exclusions.lowBQcount);
                int usableBaseCount = totalReadBases;
                usableBaseCount -= read1exclusions.basesExcludedByMapq + read1exclusions.lowBQcount;
                usableBaseCount -= read2exclusions.basesExcludedByMapq + read2exclusions.lowBQcount;
                if (read1exclusions.basesExcludedByMapq == 0 && read2exclusions.basesExcludedByMapq == 0) {
                    int overlapCount = this.getOverlappingBaseCount(read1exclusions, read2exclusions);
                    basesExcludedByOverlap += (long)overlapCount;
                    usableBaseCount -= overlapCount;
                }
                metrics.TOTAL_USABLE_BASES += (long)usableBaseCount;
                int insertSize = Math.abs(pairToAnalyze.read1.getInferredInsertSize());
                if (insertSize > 0 && pairToAnalyze.read1.getProperPairFlag()) {
                    ++metrics.TOTAL_ORIENTED_PAIRS;
                    insertSizeSum += (double)insertSize;
                }
            }
            progress.record(pairToAnalyze.read1);
            pairToAnalyze = QuerySortedReadPairIteratorUtil.getNextReadPair(iterator);
        }
        this.setUnusedMetrics(metrics);
        metrics.GENOME_TERRITORY = reader.getFileHeader().getSequenceDictionary().getReferenceLength();
        metrics.MEAN_COVERAGE = (double)metrics.TOTAL_USABLE_BASES / (double)metrics.GENOME_TERRITORY;
        metrics.PCT_EXC_DUPE = (double)basesExcludedByDupes / (double)metrics.TOTAL_BASES;
        metrics.PCT_EXC_MAPQ = (double)basesExcludedByMapq / (double)metrics.TOTAL_BASES;
        metrics.PCT_EXC_UNPAIRED = (double)basesExcludedByPairing / (double)metrics.TOTAL_BASES;
        metrics.PCT_EXC_BASEQ = (double)basesExcludedByBaseq / (double)metrics.TOTAL_BASES;
        metrics.PCT_EXC_OVERLAP = (double)basesExcludedByOverlap / (double)metrics.TOTAL_BASES;
        double totalExcludedBases = metrics.TOTAL_BASES - metrics.TOTAL_USABLE_BASES;
        metrics.PCT_EXC_TOTAL = totalExcludedBases / (double)metrics.TOTAL_BASES;
        metrics.MEAN_INSERT_SIZE = insertSizeSum / (double)metrics.TOTAL_ORIENTED_PAIRS;
        MetricsFile out = this.getMetricsFile();
        out.addMetric(metrics);
        out.write(this.OUTPUT);
        return 0;
    }

    private int getLowQualityOrSoftclipBaseCount(BaseExclusionHelper exclusions) {
        byte[] quals = exclusions.read.getBaseQualities();
        int badCount = exclusions.firstUnclippedBaseIndex + (quals.length - exclusions.firstTrailingClippedBaseIndex);
        for (int i = exclusions.firstUnclippedBaseIndex; i < exclusions.firstTrailingClippedBaseIndex; ++i) {
            if (quals[i] >= this.MINIMUM_BASE_QUALITY) continue;
            ++badCount;
        }
        return badCount;
    }

    private void setUnusedMetrics(QuerySortedSeqMetrics metrics) {
        metrics.SD_COVERAGE = -1.0;
        metrics.MEDIAN_COVERAGE = -1.0;
        metrics.MAD_COVERAGE = -1.0;
        metrics.PCT_5X = -1.0;
        metrics.PCT_10X = -1.0;
        metrics.PCT_15X = -1.0;
        metrics.PCT_20X = -1.0;
        metrics.PCT_25X = -1.0;
        metrics.PCT_30X = -1.0;
        metrics.PCT_40X = -1.0;
        metrics.PCT_50X = -1.0;
        metrics.PCT_60X = -1.0;
        metrics.PCT_70X = -1.0;
        metrics.PCT_80X = -1.0;
        metrics.PCT_90X = -1.0;
        metrics.PCT_100X = -1.0;
        metrics.PCT_EXC_CAPPED = -1.0;
    }

    private int getOverlappingBaseCount(BaseExclusionHelper read1exclusions, BaseExclusionHelper read2exclusions) {
        if (read2exclusions.read.getAlignmentStart() < read1exclusions.read.getAlignmentStart()) {
            return this.getOverlappingBaseCount(read2exclusions, read1exclusions);
        }
        if (read1exclusions.read.getAlignmentEnd() < read2exclusions.read.getAlignmentStart() || !read1exclusions.read.getReferenceIndex().equals(read2exclusions.read.getReferenceIndex())) {
            return 0;
        }
        byte[] read1quals = read1exclusions.read.getBaseQualities();
        byte[] read2quals = read2exclusions.read.getBaseQualities();
        int indexOfOverlapInFirstRead = read1exclusions.read.getReadPositionAtReferencePosition(read2exclusions.read.getAlignmentStart(), true) - 1;
        int maxPossibleOverlap = read1exclusions.firstTrailingClippedBaseIndex - indexOfOverlapInFirstRead;
        int actualOverlap = Math.min(maxPossibleOverlap, read2exclusions.firstTrailingClippedBaseIndex - read2exclusions.firstUnclippedBaseIndex);
        int numHighQualityOverlappingBases = 0;
        for (int i = 0; i < actualOverlap; ++i) {
            int posInRead1 = read1exclusions.firstTrailingClippedBaseIndex - actualOverlap + i;
            int posInRead2 = read2exclusions.firstUnclippedBaseIndex + i;
            if (read1quals[posInRead1] < this.MINIMUM_BASE_QUALITY || read2quals[posInRead2] < this.MINIMUM_BASE_QUALITY) continue;
            ++numHighQualityOverlappingBases;
        }
        return numHighQualityOverlappingBases;
    }

    private BaseExclusionHelper determineBaseExclusions(SAMRecord read) {
        BaseExclusionHelper exclusions = new BaseExclusionHelper(read);
        if (read.getMappingQuality() < this.MINIMUM_MAPPING_QUALITY) {
            exclusions.basesExcludedByMapq = read.getReadLength();
        } else {
            exclusions.lowBQcount = this.getLowQualityOrSoftclipBaseCount(exclusions);
        }
        return exclusions;
    }

    private static class BaseExclusionHelper {
        public SAMRecord read;
        public int firstUnclippedBaseIndex;
        public int firstTrailingClippedBaseIndex;
        public int basesExcludedByMapq = 0;
        public int lowBQcount = 0;

        public BaseExclusionHelper(SAMRecord read) {
            CigarOperator op;
            this.read = read;
            List<CigarElement> cigarElements = read.getCigar().getCigarElements();
            this.firstUnclippedBaseIndex = 0;
            for (CigarElement element : cigarElements) {
                op = element.getOperator();
                if (op == CigarOperator.SOFT_CLIP) {
                    this.firstUnclippedBaseIndex = element.getLength();
                    continue;
                }
                if (op == CigarOperator.HARD_CLIP) continue;
                break;
            }
            this.firstTrailingClippedBaseIndex = read.getReadLength();
            for (int i = cigarElements.size() - 1; i >= 0; --i) {
                CigarElement element;
                element = cigarElements.get(i);
                op = element.getOperator();
                if (op == CigarOperator.SOFT_CLIP) {
                    this.firstTrailingClippedBaseIndex -= element.getLength();
                    continue;
                }
                if (op != CigarOperator.HARD_CLIP) break;
            }
        }
    }

    public static class QuerySortedSeqMetrics
    extends CollectWgsMetrics.WgsMetrics {
        public long TOTAL_BASES = 0L;
        public long TOTAL_USABLE_BASES = 0L;
        public long TOTAL_READ_PAIRS = 0L;
        public long TOTAL_DUPE_PAIRS = 0L;
        public long TOTAL_ORIENTED_PAIRS = 0L;
        public double MEAN_INSERT_SIZE = 0.0;
    }
}

