/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.variant.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFContigHeaderLine;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFIDHeaderLine;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;

public class VCFUtils {
    public static Set<VCFHeaderLine> smartMergeHeaders(Collection<VCFHeader> headers, boolean emitWarnings) throws IllegalStateException {
        TreeMap<String, VCFHeaderLine> map = new TreeMap<String, VCFHeaderLine>();
        HeaderConflictWarner conflictWarner = new HeaderConflictWarner(emitWarnings);
        for (VCFHeader source : headers) {
            for (VCFHeaderLine line : source.getMetaDataInSortedOrder()) {
                String key = line.getKey();
                if (line instanceof VCFIDHeaderLine) {
                    key = key + "-" + ((VCFIDHeaderLine)((Object)line)).getID();
                }
                if (map.containsKey(key)) {
                    VCFHeaderLine other = (VCFHeaderLine)map.get(key);
                    if (line.equals(other)) continue;
                    if (!line.getClass().equals(other.getClass())) {
                        throw new IllegalStateException("Incompatible header types: " + line + " " + other);
                    }
                    if (line instanceof VCFFilterHeaderLine) {
                        String otherName;
                        String lineName = ((VCFFilterHeaderLine)line).getID();
                        if (lineName.equals(otherName = ((VCFFilterHeaderLine)other).getID())) continue;
                        throw new IllegalStateException("Incompatible header types: " + line + " " + other);
                    }
                    if (line instanceof VCFCompoundHeaderLine) {
                        VCFCompoundHeaderLine compLine = (VCFCompoundHeaderLine)line;
                        VCFCompoundHeaderLine compOther = (VCFCompoundHeaderLine)other;
                        if (!compLine.equalsExcludingDescription(compOther)) {
                            if (compLine.getType().equals((Object)compOther.getType())) {
                                conflictWarner.warn(line, "Promoting header field Number to . due to number differences in header lines: " + line + " " + other);
                                compOther.setNumberToUnbounded();
                            } else if (compLine.getType() == VCFHeaderLineType.Integer && compOther.getType() == VCFHeaderLineType.Float) {
                                conflictWarner.warn(line, "Promoting Integer to Float in header: " + compOther);
                                map.put(key, compOther);
                            } else if (compLine.getType() == VCFHeaderLineType.Float && compOther.getType() == VCFHeaderLineType.Integer) {
                                conflictWarner.warn(line, "Promoting Integer to Float in header: " + compOther);
                            } else {
                                throw new IllegalStateException("Incompatible header types, collision between these two types: " + line + " " + other);
                            }
                        }
                        if (compLine.getDescription().equals(compOther.getDescription())) continue;
                        conflictWarner.warn(line, "Allowing unequal description fields through: keeping " + compOther + " excluding " + compLine);
                        continue;
                    }
                    conflictWarner.warn(line, "Ignoring header line already in map: this header line = " + line + " already present header = " + other);
                    continue;
                }
                map.put(key, line);
            }
        }
        return new LinkedHashSet<VCFHeaderLine>(map.values());
    }

    public static VCFHeader withUpdatedContigs(VCFHeader oldHeader, File referenceFile, SAMSequenceDictionary refDict) {
        return new VCFHeader(VCFUtils.withUpdatedContigsAsLines(oldHeader.getMetaDataInInputOrder(), referenceFile, refDict), oldHeader.getGenotypeSamples());
    }

    public static Set<VCFHeaderLine> withUpdatedContigsAsLines(Set<VCFHeaderLine> oldLines, File referenceFile, SAMSequenceDictionary refDict) {
        return VCFUtils.withUpdatedContigsAsLines(oldLines, referenceFile, refDict, false);
    }

    public static Set<VCFHeaderLine> withUpdatedContigsAsLines(Set<VCFHeaderLine> oldLines, File referenceFile, SAMSequenceDictionary refDict, boolean referenceNameOnly) {
        LinkedHashSet<VCFHeaderLine> lines = new LinkedHashSet<VCFHeaderLine>(oldLines.size());
        for (VCFHeaderLine line : oldLines) {
            if (line instanceof VCFContigHeaderLine || line.getKey().equals("reference")) continue;
            lines.add(line);
        }
        for (VCFContigHeaderLine contigLine : VCFUtils.makeContigHeaderLines(refDict, referenceFile)) {
            lines.add(contigLine);
        }
        if (referenceFile != null) {
            int extensionStart;
            String referenceValue = referenceNameOnly ? ((extensionStart = referenceFile.getName().lastIndexOf(".")) == -1 ? referenceFile.getName() : referenceFile.getName().substring(0, extensionStart)) : "file://" + referenceFile.getAbsolutePath();
            lines.add(new VCFHeaderLine("reference", referenceValue));
        }
        return lines;
    }

    public static List<VCFContigHeaderLine> makeContigHeaderLines(SAMSequenceDictionary refDict, File referenceFile) {
        ArrayList<VCFContigHeaderLine> lines = new ArrayList<VCFContigHeaderLine>();
        String assembly = referenceFile != null ? VCFUtils.getReferenceAssembly(referenceFile.getName()) : null;
        for (SAMSequenceRecord contig : refDict.getSequences()) {
            lines.add(VCFUtils.makeContigHeaderLine(contig, assembly));
        }
        return lines;
    }

    private static VCFContigHeaderLine makeContigHeaderLine(SAMSequenceRecord contig, String assembly) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(3);
        map.put("ID", contig.getSequenceName());
        map.put("length", String.valueOf(contig.getSequenceLength()));
        if (assembly != null) {
            map.put("assembly", assembly);
        }
        return new VCFContigHeaderLine(map, contig.getSequenceIndex());
    }

    private static String getReferenceAssembly(String refPath) {
        String assembly = null;
        if (refPath.contains("b37") || refPath.contains("v37")) {
            assembly = "b37";
        } else if (refPath.contains("b36")) {
            assembly = "b36";
        } else if (refPath.contains("hg18")) {
            assembly = "hg18";
        } else if (refPath.contains("hg19")) {
            assembly = "hg19";
        }
        return assembly;
    }

    private static final class HeaderConflictWarner {
        boolean emitWarnings;
        Set<String> alreadyIssued = new HashSet<String>();

        private HeaderConflictWarner(boolean emitWarnings) {
            this.emitWarnings = emitWarnings;
        }

        public void warn(VCFHeaderLine line, String msg) {
        }
    }
}

