/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.common.MutableInt;
import htsjdk.samtools.cram.encoding.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.ExternalCompressor;
import htsjdk.samtools.cram.encoding.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.NullEncoding;
import htsjdk.samtools.cram.encoding.SubexponentialIntegerEncoding;
import htsjdk.samtools.cram.encoding.huffman.HuffmanCode;
import htsjdk.samtools.cram.encoding.huffman.HuffmanTree;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.huffman.codec.HuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.rans.RANS;
import htsjdk.samtools.cram.encoding.readfeatures.Deletion;
import htsjdk.samtools.cram.encoding.readfeatures.HardClip;
import htsjdk.samtools.cram.encoding.readfeatures.Padding;
import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import htsjdk.samtools.cram.encoding.readfeatures.RefSkip;
import htsjdk.samtools.cram.encoding.readfeatures.Substitution;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.cram.structure.EncodingKey;
import htsjdk.samtools.cram.structure.EncodingParams;
import htsjdk.samtools.cram.structure.ReadTag;
import htsjdk.samtools.cram.structure.SubstitutionMatrix;
import htsjdk.samtools.util.Log;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;

public class CompressionHeaderFactory {
    private static final Charset charset = Charset.forName("US-ASCII");
    private static final Log log = Log.getInstance(CompressionHeaderFactory.class);
    private static final int oqz = ReadTag.nameType3BytesToInt("OQ", 'Z');
    private static final int bqz = ReadTag.nameType3BytesToInt("BQ", 'Z');

    public CompressionHeader build(List<CramCompressionRecord> records, SubstitutionMatrix substitutionMatrix, boolean sorted) {
        CompressionHeader header = new CompressionHeader();
        header.externalIds = new ArrayList<Integer>();
        int exCounter = 0;
        int baseID = exCounter++;
        header.externalIds.add(baseID);
        header.externalCompressors.put(baseID, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        int qualityScoreID = exCounter++;
        header.externalIds.add(qualityScoreID);
        header.externalCompressors.put(qualityScoreID, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        int readNameID = exCounter++;
        header.externalIds.add(readNameID);
        header.externalCompressors.put(readNameID, ExternalCompressor.createGZIP());
        int mateInfoID = exCounter++;
        header.externalIds.add(mateInfoID);
        header.externalCompressors.put(mateInfoID, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        header.encodingMap = new TreeMap<EncodingKey, EncodingParams>();
        for (EncodingKey key : EncodingKey.values()) {
            header.encodingMap.put(key, NullEncoding.toParam());
        }
        header.tMap = new TreeMap<Integer, EncodingParams>();
        CompressionHeaderFactory.getOptimalIntegerEncoding(header, EncodingKey.BF_BitFlags, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(header, EncodingKey.CF_CompressionBitFlags, 0, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(header, EncodingKey.RI_RefId, -2, records);
        CompressionHeaderFactory.getOptimalIntegerEncoding(header, EncodingKey.RL_ReadLength, 0, records);
        if (sorted) {
            header.APDelta = true;
            CompressionHeaderFactory.getOptimalIntegerEncoding(header, EncodingKey.AP_AlignmentPositionOffset, 0, records);
        } else {
            int aStartID = exCounter++;
            header.APDelta = false;
            header.encodingMap.put(EncodingKey.AP_AlignmentPositionOffset, ExternalIntegerEncoding.toParam(aStartID));
            header.externalIds.add(aStartID);
            header.externalCompressors.put(aStartID, ExternalCompressor.createRANS(RANS.ORDER.ONE));
            log.debug("Assigned external id to alignment starts: " + aStartID);
        }
        CompressionHeaderFactory.getOptimalIntegerEncoding(header, EncodingKey.RG_ReadGroup, -1, records);
        HuffmanParamsCalculator calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            calculator.add(record.readName.length());
        }
        calculator.calculate();
        header.encodingMap.put(EncodingKey.RN_ReadName, ByteArrayLenEncoding.toParam(HuffmanIntegerEncoding.toParam(calculator.values(), calculator.bitLens()), ExternalByteArrayEncoding.toParam(readNameID)));
        IntegerEncodingCalculator calc = new IntegerEncodingCalculator(EncodingKey.NF_RecordsToNextFragment.name(), 0);
        for (CramCompressionRecord r : records) {
            if (!r.isHasMateDownStream()) continue;
            calc.addValue(r.recordsToNextFragment);
        }
        Encoding<Integer> bestEncoding = calc.getBestEncoding();
        header.encodingMap.put(EncodingKey.NF_RecordsToNextFragment, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            calculator.add(record.tags == null ? 0 : record.tags.length);
        }
        calculator.calculate();
        header.encodingMap.put(EncodingKey.TC_TagCount, HuffmanIntegerEncoding.toParam(calculator.values(), calculator.bitLens()));
        calculator = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (record.tags == null) continue;
            for (ReadTag tag : record.tags) {
                calculator.add(tag.keyType3BytesAsInt);
            }
        }
        calculator.calculate();
        header.encodingMap.put(EncodingKey.TN_TagNameAndType, HuffmanIntegerEncoding.toParam(calculator.values(), calculator.bitLens()));
        Comparator<ReadTag> comparator = new Comparator<ReadTag>(){

            @Override
            public int compare(ReadTag o1, ReadTag o2) {
                return o1.keyType3BytesAsInt - o2.keyType3BytesAsInt;
            }
        };
        Comparator<byte[]> baComparator = new Comparator<byte[]>(){

            @Override
            public int compare(byte[] o1, byte[] o2) {
                if (o1.length - o2.length != 0) {
                    return o1.length - o2.length;
                }
                for (int i = 0; i < o1.length; ++i) {
                    if (o1[i] == o2[i]) continue;
                    return o1[i] - o2[i];
                }
                return 0;
            }
        };
        TreeMap<byte[], MutableInt> map = new TreeMap<byte[], MutableInt>(baComparator);
        MutableInt noTagCounter = new MutableInt();
        map.put(new byte[0], noTagCounter);
        for (CramCompressionRecord record : records) {
            if (record.tags == null) {
                ++noTagCounter.value;
                record.tagIdsIndex = noTagCounter;
                continue;
            }
            Arrays.sort(record.tags, comparator);
            record.tagIds = new byte[record.tags.length * 3];
            int tagIndex = 0;
            for (int i = 0; i < record.tags.length; ++i) {
                record.tagIds[i * 3] = (byte)record.tags[tagIndex].keyType3Bytes.charAt(0);
                record.tagIds[i * 3 + 1] = (byte)record.tags[tagIndex].keyType3Bytes.charAt(1);
                record.tagIds[i * 3 + 2] = (byte)record.tags[tagIndex].keyType3Bytes.charAt(2);
                ++tagIndex;
            }
            MutableInt count = (MutableInt)map.get(record.tagIds);
            if (count == null) {
                count = new MutableInt();
                map.put(record.tagIds, count);
            }
            ++count.value;
            record.tagIdsIndex = count;
        }
        byte[][][] dic = new byte[map.size()][][];
        int i = 0;
        HuffmanParamsCalculator calculator2 = new HuffmanParamsCalculator();
        for (byte[] idsAsBytes : map.keySet()) {
            int nofIds = idsAsBytes.length / 3;
            dic[i] = new byte[nofIds][];
            int j = 0;
            while (j < idsAsBytes.length) {
                int idIndex = j / 3;
                dic[i][idIndex] = new byte[3];
                dic[i][idIndex][0] = idsAsBytes[j++];
                dic[i][idIndex][1] = idsAsBytes[j++];
                dic[i][idIndex][2] = idsAsBytes[j++];
            }
            calculator2.add(i, ((MutableInt)map.get((Object)idsAsBytes)).value);
            ((MutableInt)map.get((Object)idsAsBytes)).value = i++;
        }
        calculator2.calculate();
        header.encodingMap.put(EncodingKey.TL_TagIdList, HuffmanIntegerEncoding.toParam(calculator2.values(), calculator2.bitLens()));
        header.dictionary = dic;
        int unsortedTagValueExternalID = exCounter;
        header.externalIds.add(unsortedTagValueExternalID);
        header.externalCompressors.put(unsortedTagValueExternalID, ExternalCompressor.createRANS(RANS.ORDER.ONE));
        HashSet<Integer> tagIdSet = new HashSet<Integer>();
        for (CramCompressionRecord record : records) {
            if (record.tags == null) continue;
            for (ReadTag tag : record.tags) {
                tagIdSet.add(tag.keyType3BytesAsInt);
            }
        }
        Iterator<CramCompressionRecord> i$ = tagIdSet.iterator();
        while (i$.hasNext()) {
            int externalID;
            int id = (Integer)((Object)i$.next());
            byte type = (byte)(id & 0xFF);
            switch (type) {
                case 66: 
                case 90: {
                    externalID = id;
                    break;
                }
                default: {
                    externalID = unsortedTagValueExternalID;
                }
            }
            header.externalIds.add(externalID);
            header.externalCompressors.put(externalID, ExternalCompressor.createRANS(RANS.ORDER.ONE));
            header.tMap.put(id, ByteArrayLenEncoding.toParam(ExternalIntegerEncoding.toParam(externalID), ExternalByteEncoding.toParam(externalID)));
        }
        Object calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord r : records) {
            ((HuffmanParamsCalculator)calculator22).add(r.readFeatures == null ? 0 : r.readFeatures.size());
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.FN_NumberOfReadFeatures, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values(), ((HuffmanParamsCalculator)calculator22).bitLens()));
        calc = new IntegerEncodingCalculator("read feature position", 0);
        for (CramCompressionRecord record : records) {
            int prevPos = 0;
            if (record.readFeatures == null) continue;
            for (ReadFeature rf : record.readFeatures) {
                calc.addValue(rf.getPosition() - prevPos);
                prevPos = rf.getPosition();
            }
        }
        bestEncoding = calc.getBestEncoding();
        header.encodingMap.put(EncodingKey.FP_FeaturePosition, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature readFeature : record.readFeatures) {
                ((HuffmanParamsCalculator)calculator22).add(readFeature.getOperator());
            }
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.FC_FeatureCode, HuffmanByteEncoding.toParam(((HuffmanParamsCalculator)calculator22).valuesAsBytes(), ((HuffmanParamsCalculator)calculator22).bitLens));
        header.encodingMap.put(EncodingKey.BA_Base, ExternalByteEncoding.toParam(baseID));
        header.encodingMap.put(EncodingKey.QS_QualityScore, ExternalByteEncoding.toParam(qualityScoreID));
        if (substitutionMatrix == null) {
            long[][] frequencies = new long[200][200];
            for (CramCompressionRecord record : records) {
                if (record.readFeatures == null) continue;
                for (ReadFeature readFeature : record.readFeatures) {
                    if (readFeature.getOperator() != 88) continue;
                    Substitution substitution = (Substitution)readFeature;
                    byte refBase = substitution.getReferenceBase();
                    byte base = substitution.getBase();
                    long[] lArray = frequencies[refBase];
                    byte by = base;
                    lArray[by] = lArray[by] + 1L;
                }
            }
            header.substitutionMatrix = new SubstitutionMatrix(frequencies);
        } else {
            header.substitutionMatrix = substitutionMatrix;
        }
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature recordFeature : record.readFeatures) {
                if (recordFeature.getOperator() != 88) continue;
                Substitution substitution = (Substitution)recordFeature;
                if (substitution.getCode() == -1) {
                    byte refBase = substitution.getReferenceBase();
                    byte base = substitution.getBase();
                    substitution.setCode(header.substitutionMatrix.code(refBase, base));
                }
                ((HuffmanParamsCalculator)calculator22).add(substitution.getCode());
            }
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.BS_BaseSubstitutionCode, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values, ((HuffmanParamsCalculator)calculator22).bitLens));
        header.encodingMap.put(EncodingKey.IN_Insertion, ByteArrayStopEncoding.toParam((byte)0, baseID));
        header.encodingMap.put(EncodingKey.SC_SoftClip, ByteArrayStopEncoding.toParam((byte)0, baseID));
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature recordFeature : record.readFeatures) {
                if (recordFeature.getOperator() != 68) continue;
                ((HuffmanParamsCalculator)calculator22).add(((Deletion)recordFeature).getLength());
            }
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.DL_DeletionLength, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values, ((HuffmanParamsCalculator)calculator22).bitLens));
        calculator22 = new IntegerEncodingCalculator(EncodingKey.HC_HardClip.name(), 0);
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature recordFeature : record.readFeatures) {
                if (recordFeature.getOperator() != 72) continue;
                ((IntegerEncodingCalculator)calculator22).addValue(((HardClip)recordFeature).getLength());
            }
        }
        bestEncoding = ((IntegerEncodingCalculator)calculator22).getBestEncoding();
        header.encodingMap.put(EncodingKey.HC_HardClip, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator22 = new IntegerEncodingCalculator(EncodingKey.PD_padding.name(), 0);
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature recordFeature : record.readFeatures) {
                if (recordFeature.getOperator() != 80) continue;
                ((IntegerEncodingCalculator)calculator22).addValue(((Padding)recordFeature).getLength());
            }
        }
        bestEncoding = ((IntegerEncodingCalculator)calculator22).getBestEncoding();
        header.encodingMap.put(EncodingKey.PD_padding, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (record.readFeatures == null) continue;
            for (ReadFeature recordFeature : record.readFeatures) {
                if (recordFeature.getOperator() != 78) continue;
                ((HuffmanParamsCalculator)calculator22).add(((RefSkip)recordFeature).getLength());
            }
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.RS_RefSkip, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values, ((HuffmanParamsCalculator)calculator22).bitLens));
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (record.isSegmentUnmapped()) continue;
            ((HuffmanParamsCalculator)calculator22).add(record.mappingQuality);
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.MQ_MappingQualityScore, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values(), ((HuffmanParamsCalculator)calculator22).bitLens));
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            ((HuffmanParamsCalculator)calculator22).add(record.getMateFlags());
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        header.encodingMap.put(EncodingKey.MF_MateBitFlags, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values, ((HuffmanParamsCalculator)calculator22).bitLens));
        calculator22 = new HuffmanParamsCalculator();
        for (CramCompressionRecord record : records) {
            if (!record.isDetached()) continue;
            ((HuffmanParamsCalculator)calculator22).add(record.mateSequenceID);
        }
        ((HuffmanParamsCalculator)calculator22).calculate();
        if (((HuffmanParamsCalculator)calculator22).values.length == 0) {
            header.encodingMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, NullEncoding.toParam());
        }
        header.encodingMap.put(EncodingKey.NS_NextFragmentReferenceSequenceID, HuffmanIntegerEncoding.toParam(((HuffmanParamsCalculator)calculator22).values(), ((HuffmanParamsCalculator)calculator22).bitLens()));
        log.debug("NS: " + header.encodingMap.get((Object)EncodingKey.NS_NextFragmentReferenceSequenceID));
        header.encodingMap.put(EncodingKey.NP_NextFragmentAlignmentStart, ExternalIntegerEncoding.toParam(mateInfoID));
        header.encodingMap.put(EncodingKey.TS_InsetSize, ExternalIntegerEncoding.toParam(mateInfoID));
        return header;
    }

    private static int getValue(EncodingKey key, CramCompressionRecord record) {
        switch (key) {
            case AP_AlignmentPositionOffset: {
                return record.alignmentDelta;
            }
            case BF_BitFlags: {
                return record.flags;
            }
            case CF_CompressionBitFlags: {
                return record.compressionFlags;
            }
            case FN_NumberOfReadFeatures: {
                return record.readFeatures == null ? 0 : record.readFeatures.size();
            }
            case MF_MateBitFlags: {
                return record.mateFlags;
            }
            case MQ_MappingQualityScore: {
                return record.mappingQuality;
            }
            case NF_RecordsToNextFragment: {
                return record.recordsToNextFragment;
            }
            case NP_NextFragmentAlignmentStart: {
                return record.mateAlignmentStart;
            }
            case NS_NextFragmentReferenceSequenceID: {
                return record.mateSequenceID;
            }
            case RG_ReadGroup: {
                return record.readGroupID;
            }
            case RI_RefId: {
                return record.sequenceId;
            }
            case RL_ReadLength: {
                return record.readLength;
            }
            case TC_TagCount: {
                return record.tags == null ? 0 : record.tags.length;
            }
        }
        throw new RuntimeException("Unexpected encoding key: " + key.name());
    }

    private static void getOptimalIntegerEncoding(CompressionHeader header, EncodingKey key, int minValue, List<CramCompressionRecord> records) {
        IntegerEncodingCalculator calc = new IntegerEncodingCalculator(key.name(), minValue);
        for (CramCompressionRecord record : records) {
            int value = CompressionHeaderFactory.getValue(key, record);
            calc.addValue(value);
        }
        Encoding<Integer> bestEncoding = calc.getBestEncoding();
        header.encodingMap.put(key, new EncodingParams(bestEncoding.id(), bestEncoding.toByteArray()));
    }

    private static Integer[] autobox(int[] array) {
        Integer[] newArray = new Integer[array.length];
        for (int i = 0; i < array.length; ++i) {
            newArray[i] = array[i];
        }
        return newArray;
    }

    public static class IntegerEncodingCalculator {
        public final List<EncodingLengthCalculator> calculators = new ArrayList<EncodingLengthCalculator>();
        private int max = 0;
        private int count = 0;
        private final String name;
        private HashMap<Integer, MutableInt> dictionary = new HashMap();
        private final int dictionaryThreshold = 100;
        private final int minValue;

        public IntegerEncodingCalculator(String name, int dictionaryThreshold, int minValue) {
            this.name = name;
            this.minValue = minValue;
            this.calculators.add(new EncodingLengthCalculator(new GammaIntegerEncoding(1 - minValue)));
            for (int i = 2; i < 5; ++i) {
                this.calculators.add(new EncodingLengthCalculator(new SubexponentialIntegerEncoding(0 - minValue, i)));
            }
            this.dictionary = dictionaryThreshold < 1 ? null : new HashMap();
        }

        public IntegerEncodingCalculator(String name, int minValue) {
            this(name, 255, minValue);
        }

        public void addValue(int value) {
            ++this.count;
            if (value > this.max) {
                this.max = value;
            }
            for (EncodingLengthCalculator calculator : this.calculators) {
                calculator.add(value);
            }
            if (this.dictionary != null) {
                if (this.dictionary.size() >= 99) {
                    this.dictionary = null;
                } else {
                    MutableInt mutableInt = this.dictionary.get(value);
                    if (mutableInt == null) {
                        mutableInt = new MutableInt();
                        this.dictionary.put(value, mutableInt);
                    }
                    ++mutableInt.value;
                }
            }
        }

        public Encoding<Integer> getBestEncoding() {
            int betaLength;
            if (this.dictionary != null && this.dictionary.size() == 1) {
                int value = this.dictionary.keySet().iterator().next();
                EncodingParams param = HuffmanIntegerEncoding.toParam(new int[]{value}, new int[]{0});
                HuffmanIntegerEncoding huffmanEncoding = new HuffmanIntegerEncoding();
                huffmanEncoding.fromByteArray(param.params);
                return huffmanEncoding;
            }
            EncodingLengthCalculator bestCalculator = this.calculators.get(0);
            for (EncodingLengthCalculator calculator : this.calculators) {
                if (calculator.length() >= bestCalculator.length()) continue;
                bestCalculator = calculator;
            }
            Encoding bestEncoding = bestCalculator.encoding;
            long bits = bestCalculator.length();
            if (bits > (long)((betaLength = (int)Math.round(Math.log(this.max - this.minValue) / Math.log(2.0) + 0.5)) * this.count)) {
                bestEncoding = new BetaIntegerEncoding(-this.minValue, betaLength);
                bits = betaLength * this.count;
            }
            if (this.dictionary != null) {
                HuffmanParamsCalculator huffmanParamsCalculator = new HuffmanParamsCalculator();
                for (Integer value : this.dictionary.keySet()) {
                    huffmanParamsCalculator.add(value, this.dictionary.get((Object)value).value);
                }
                huffmanParamsCalculator.calculate();
                EncodingParams param = HuffmanIntegerEncoding.toParam(huffmanParamsCalculator.values(), huffmanParamsCalculator.bitLens());
                HuffmanIntegerEncoding huffmanEncoding = new HuffmanIntegerEncoding();
                huffmanEncoding.fromByteArray(param.params);
                EncodingLengthCalculator calculator = new EncodingLengthCalculator(huffmanEncoding);
                for (Integer key : this.dictionary.keySet()) {
                    calculator.add(key, this.dictionary.get((Object)key).value);
                }
                if (calculator.length() < bits) {
                    bestEncoding = huffmanEncoding;
                    bits = calculator.length();
                }
            }
            byte[] params = bestEncoding.toByteArray();
            params = Arrays.copyOf(params, Math.min(params.length, 20));
            log.debug("Best encoding for " + this.name + ": " + bestEncoding.id().name() + Arrays.toString(params) + ", bits=" + bits);
            return bestEncoding;
        }
    }

    public static class EncodingLengthCalculator {
        private final BitCodec<Integer> codec;
        private final Encoding<Integer> encoding;
        private long length;

        public EncodingLengthCalculator(Encoding<Integer> encoding) {
            this.encoding = encoding;
            this.codec = encoding.buildCodec(null, null);
        }

        public void add(int value) {
            this.length += this.codec.numberOfBits(value);
        }

        public void add(int value, int inc) {
            this.length += (long)inc * this.codec.numberOfBits(value);
        }

        public long length() {
            return this.length;
        }
    }

    public static class HuffmanParamsCalculator {
        private final HashMap<Integer, MutableInt> countMap = new HashMap();
        private int[] values = new int[0];
        private int[] bitLens = new int[0];

        public void add(int value) {
            MutableInt counter = this.countMap.get(value);
            if (counter == null) {
                counter = new MutableInt();
                this.countMap.put(value, counter);
            }
            ++counter.value;
        }

        public void add(Integer value, int inc) {
            MutableInt counter = this.countMap.get(value);
            if (counter == null) {
                counter = new MutableInt();
                this.countMap.put(value, counter);
            }
            counter.value += inc;
        }

        public int[] bitLens() {
            return this.bitLens;
        }

        public int[] values() {
            return this.values;
        }

        public Integer[] valuesAsAutoIntegers() {
            Integer[] intValues = new Integer[this.values.length];
            for (int i = 0; i < intValues.length; ++i) {
                intValues[i] = this.values[i];
            }
            return intValues;
        }

        public byte[] valuesAsBytes() {
            byte[] byteValues = new byte[this.values.length];
            for (int i = 0; i < byteValues.length; ++i) {
                byteValues[i] = (byte)(0xFF & this.values[i]);
            }
            return byteValues;
        }

        public Byte[] valuesAsAutoBytes() {
            Byte[] byteValues = new Byte[this.values.length];
            for (int i = 0; i < byteValues.length; ++i) {
                byteValues[i] = (byte)(0xFF & this.values[i]);
            }
            return byteValues;
        }

        public void calculate() {
            int size = this.countMap.size();
            int[] frequencies = new int[size];
            int[] values = new int[size];
            int i = 0;
            for (Integer key : this.countMap.keySet()) {
                values[i] = key;
                frequencies[i] = this.countMap.get((Object)key).value;
                ++i;
            }
            HuffmanTree<Integer> tree = HuffmanCode.buildTree(frequencies, CompressionHeaderFactory.autobox(values));
            ArrayList valueList = new ArrayList();
            ArrayList<Integer> lens = new ArrayList<Integer>();
            HuffmanCode.getValuesAndBitLengths(valueList, lens, tree);
            Object[] codes = new BitCode[valueList.size()];
            for (i = 0; i < valueList.size(); ++i) {
                codes[i] = new BitCode((Integer)valueList.get(i), (Integer)lens.get(i));
            }
            Arrays.sort(codes);
            this.values = new int[codes.length];
            this.bitLens = new int[codes.length];
            for (i = 0; i < codes.length; ++i) {
                Object code = codes[i];
                this.bitLens[i] = ((BitCode)code).length;
                this.values[i] = ((BitCode)code).value;
            }
        }
    }

    private static class BitCode
    implements Comparable<BitCode> {
        final int value;
        final int length;

        public BitCode(int value, int length) {
            this.value = value;
            this.length = length;
        }

        @Override
        public int compareTo(BitCode o) {
            int result = this.value - o.value;
            if (result != 0) {
                return result;
            }
            return this.length - o.length;
        }
    }
}

