/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMSequenceRecord;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement(name="References")
public class SAMSequenceDictionary
implements Serializable {
    public static final long serialVersionUID = 1L;
    @XmlElement(name="Reference")
    private List<SAMSequenceRecord> mSequences = new ArrayList<SAMSequenceRecord>();
    private final Map<String, SAMSequenceRecord> mSequenceMap = new HashMap<String, SAMSequenceRecord>();
    private static String DICT_MISMATCH_TEMPLATE = "SAM dictionaries are not the same: %s.";

    public SAMSequenceDictionary() {
    }

    public SAMSequenceDictionary(List<SAMSequenceRecord> list) {
        this();
        this.setSequences(list);
    }

    @XmlTransient
    public List<SAMSequenceRecord> getSequences() {
        return Collections.unmodifiableList(this.mSequences);
    }

    public SAMSequenceRecord getSequence(String name) {
        return this.mSequenceMap.get(name);
    }

    public void setSequences(List<SAMSequenceRecord> list) {
        this.mSequences = list;
        this.mSequenceMap.clear();
        int index = 0;
        for (SAMSequenceRecord record : list) {
            record.setSequenceIndex(index++);
            if (this.mSequenceMap.put(record.getSequenceName(), record) == null) continue;
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + record.getSequenceName());
        }
    }

    public void addSequence(SAMSequenceRecord sequenceRecord) {
        if (this.mSequenceMap.containsKey(sequenceRecord.getSequenceName())) {
            throw new IllegalArgumentException("Cannot add sequence that already exists in SAMSequenceDictionary: " + sequenceRecord.getSequenceName());
        }
        sequenceRecord.setSequenceIndex(this.mSequences.size());
        this.mSequences.add(sequenceRecord);
        this.mSequenceMap.put(sequenceRecord.getSequenceName(), sequenceRecord);
    }

    public SAMSequenceRecord getSequence(int sequenceIndex) {
        if (sequenceIndex < 0 || sequenceIndex >= this.mSequences.size()) {
            return null;
        }
        return this.mSequences.get(sequenceIndex);
    }

    public int getSequenceIndex(String sequenceName) {
        SAMSequenceRecord record = this.mSequenceMap.get(sequenceName);
        if (record == null) {
            return -1;
        }
        return record.getSequenceIndex();
    }

    public int size() {
        return this.mSequences.size();
    }

    public long getReferenceLength() {
        long len = 0L;
        for (SAMSequenceRecord seq : this.getSequences()) {
            len += (long)seq.getSequenceLength();
        }
        return len;
    }

    public boolean isEmpty() {
        return this.mSequences.isEmpty();
    }

    public void assertSameDictionary(SAMSequenceDictionary that) {
        if (this == that) {
            return;
        }
        Iterator<SAMSequenceRecord> thatSequences = that.mSequences.iterator();
        for (SAMSequenceRecord thisSequence : this.mSequences) {
            if (!thatSequences.hasNext()) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thisSequence + " is present in only one dictionary"));
            }
            SAMSequenceRecord thatSequence = thatSequences.next();
            if (!thatSequence.isSameSequence(thisSequence)) {
                throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thatSequence + " was found when " + thisSequence + " was expected"));
            }
        }
        if (thatSequences.hasNext()) {
            throw new AssertionError((Object)String.format(DICT_MISMATCH_TEMPLATE, thatSequences.next() + " is present in only one dictionary"));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SAMSequenceDictionary that = (SAMSequenceDictionary)o;
        return ((Object)this.mSequences).equals(that.mSequences);
    }

    public SAMSequenceRecord addSequenceAlias(String originalName, String altName) {
        if (originalName == null) {
            throw new IllegalArgumentException("original name cannot be null");
        }
        if (altName == null) {
            throw new IllegalArgumentException("alt name cannot be null");
        }
        SAMSequenceRecord originalSeqRecord = this.getSequence(originalName);
        if (originalSeqRecord == null) {
            throw new IllegalArgumentException("Sequence " + originalName + " doesn't exist in dictionary.");
        }
        if (originalName.equals(altName)) {
            return originalSeqRecord;
        }
        SAMSequenceRecord altSeqRecord = this.getSequence(altName);
        if (altSeqRecord != null) {
            if (altSeqRecord.equals(originalSeqRecord)) {
                return originalSeqRecord;
            }
            throw new IllegalArgumentException("Alias " + altName + " was already set to " + altSeqRecord.getSequenceName());
        }
        this.mSequenceMap.put(altName, originalSeqRecord);
        return originalSeqRecord;
    }

    public String md5() {
        if (this.isEmpty()) {
            return "";
        }
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.reset();
            for (SAMSequenceRecord samSequenceRecord : this.mSequences) {
                String md5_tag;
                if (samSequenceRecord.getSequenceIndex() > 0) {
                    md5.update((byte)32);
                }
                if ((md5_tag = samSequenceRecord.getAttribute("M5")) != null) {
                    md5.update(md5_tag.getBytes());
                    continue;
                }
                md5.update(samSequenceRecord.getSequenceName().getBytes());
                md5.update(String.valueOf(samSequenceRecord.getSequenceLength()).getBytes());
            }
            String hash = new BigInteger(1, md5.digest()).toString(16);
            if (hash.length() != 32) {
                String zeros = "00000000000000000000000000000000";
                hash = "00000000000000000000000000000000".substring(0, 32 - hash.length()) + hash;
            }
            return hash;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public int hashCode() {
        return ((Object)this.mSequences).hashCode();
    }

    public String toString() {
        return "SAMSequenceDictionary:( sequences:" + this.size() + " length:" + this.getReferenceLength() + " " + " md5:" + this.md5() + ")";
    }
}

