/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import picard.util.DbSnpBitSetUtil;
import picard.vcf.CollectVariantCallingMetrics;
import picard.vcf.processor.VariantProcessor;

public class CallingMetricAccumulator
implements VariantProcessor.Accumulator<Result> {
    private static final Log LOG = Log.getInstance(CallingMetricAccumulator.class);
    private static final ProgressLogger progress = new ProgressLogger(LOG, 10000);
    private final DbSnpBitSetUtil.DbSnpBitSets dbsnp;
    private final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summaryMetric = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
    private final CollectionUtil.DefaultingMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics> sampleMetricsMap = new CollectionUtil.DefaultingMap<String, CollectVariantCallingMetrics.VariantCallingDetailMetrics>(new CollectionUtil.DefaultingMap.Factory<CollectVariantCallingMetrics.VariantCallingDetailMetrics, String>(){

        @Override
        public CollectVariantCallingMetrics.VariantCallingDetailMetrics make(String sampleName) {
            CollectVariantCallingMetrics.VariantCallingDetailMetrics detail = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
            detail.SAMPLE_ALIAS = sampleName;
            return detail;
        }
    }, true);

    public CallingMetricAccumulator(DbSnpBitSetUtil.DbSnpBitSets dbsnp) {
        this.dbsnp = dbsnp;
    }

    @Override
    public void accumulate(VariantContext vc) {
        progress.record(vc.getChr(), vc.getStart());
        if (!this.isVariantExcluded(vc)) {
            String singletonSample = this.getSingletonSample(vc);
            this.updateSummaryMetric(this.summaryMetric, null, vc, singletonSample != null);
            for (String sampleName : vc.getSampleNames()) {
                if (vc.getGenotype(sampleName).isHomRef()) continue;
                this.updateDetailMetric(this.sampleMetricsMap.get(sampleName), vc.getGenotype(sampleName), vc, sampleName.equals(singletonSample));
            }
        }
    }

    private String getSingletonSample(VariantContext vc) {
        String singletonSample = null;
        for (String sampleName : vc.getSampleNames()) {
            Genotype genotype = vc.getGenotype(sampleName);
            if (genotype.isHomVar()) {
                return null;
            }
            if (!genotype.isHet()) continue;
            if (singletonSample != null) {
                return null;
            }
            singletonSample = sampleName;
        }
        return singletonSample;
    }

    @Override
    public Result result() {
        Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> values = this.sampleMetricsMap.values();
        for (CollectVariantCallingMetrics.VariantCallingDetailMetrics value : values) {
            value.updateDerivedValuesInPlace();
        }
        this.summaryMetric.updateDerivedValuesInPlace();
        return new Result(this.summaryMetric, values);
    }

    private boolean isVariantExcluded(VariantContext vc) {
        if (!vc.isVariant()) {
            return true;
        }
        for (String sample : vc.getSampleNames()) {
            if (vc.getGenotype(sample).isHomRef()) continue;
            return false;
        }
        return true;
    }

    private void updateDetailMetric(CollectVariantCallingMetrics.VariantCallingDetailMetrics metric, Genotype genotype, VariantContext vc, boolean hasSingletonSample) {
        this.updateSummaryMetric(metric, genotype, vc, hasSingletonSample);
        if (genotype != null && !vc.isFiltered()) {
            if (genotype.isHet()) {
                ++metric.numHets;
            } else if (genotype.isHomVar()) {
                ++metric.numHomVar;
            }
        }
    }

    private void updateSummaryMetric(CollectVariantCallingMetrics.VariantCallingSummaryMetrics metric, Genotype genotype, VariantContext vc, boolean hasSingletonSample) {
        if (genotype != null && genotype.isNoCall()) {
            return;
        }
        if (vc.isFiltered()) {
            if (vc.isSNP()) {
                ++metric.FILTERED_SNPS;
            } else if (vc.isIndel()) {
                ++metric.FILTERED_INDELS;
            }
            return;
        }
        if (hasSingletonSample) {
            ++metric.NUM_SINGLETONS;
        }
        if (vc.isBiallelic() && vc.isSNP()) {
            boolean isInDbSnp = this.dbsnp.snps.isDbSnpSite(vc.getChr(), vc.getStart());
            boolean isTransition = CallingMetricAccumulator.isTransition(vc);
            ++metric.TOTAL_SNPS;
            if (isInDbSnp) {
                ++metric.NUM_IN_DB_SNP;
                if (isTransition) {
                    ++metric.dbSnpTransitions;
                } else {
                    ++metric.dbSnpTransversions;
                }
            } else if (isTransition) {
                ++metric.novelTransitions;
            } else {
                ++metric.novelTransversions;
            }
            if (genotype != null && genotype.isHet()) {
                int[] alleleDepths = genotype.getAD();
                if (alleleDepths != null) {
                    int indexOfRef = vc.getAlleleIndex(vc.getReference());
                    int indexOfAlt = (indexOfRef + 1) % 2;
                    metric.refAlleleObs += (long)alleleDepths[indexOfRef];
                    metric.altAlleleObs += (long)alleleDepths[indexOfAlt];
                    this.summaryMetric.refAlleleObs += (long)alleleDepths[indexOfRef];
                    this.summaryMetric.altAlleleObs += (long)alleleDepths[indexOfAlt];
                } else {
                    LOG.debug("Skipping aggregation of genotype due to missing allele depth data: ", genotype, ".");
                }
            }
        } else if (vc.isSNP() && vc.getAlternateAlleles().size() > 1) {
            metric.TOTAL_MULTIALLELIC_SNPS += 1.0;
            if (this.dbsnp.snps.isDbSnpSite(vc.getChr(), vc.getStart())) {
                metric.NUM_IN_DB_SNP_MULTIALLELIC += 1.0;
            }
        } else if (vc.isIndel() && !vc.isComplexIndel()) {
            boolean isInDbSnp = this.dbsnp.indels.isDbSnpSite(vc.getChr(), vc.getStart());
            boolean isInsertion = vc.isSimpleInsertion();
            ++metric.TOTAL_INDELS;
            if (isInDbSnp) {
                ++metric.NUM_IN_DB_SNP_INDELS;
                if (isInsertion) {
                    ++metric.dbSnpInsertions;
                } else {
                    ++metric.dbSnpDeletions;
                }
            } else if (isInsertion) {
                ++metric.novelInsertions;
            } else {
                ++metric.novelDeletions;
            }
        } else if (vc.isComplexIndel()) {
            metric.TOTAL_COMPLEX_INDELS += 1.0;
            if (this.dbsnp.indels.isDbSnpSite(vc.getChr(), vc.getStart())) {
                metric.NUM_IN_DB_SNP_COMPLEX_INDELS += 1.0;
            }
        }
    }

    private static boolean isTransition(VariantContext vc) {
        byte refAllele = vc.getReference().getBases()[0];
        List<Allele> altAlleles = vc.getAlternateAlleles();
        Byte altAllele = null;
        for (Allele a : altAlleles) {
            if (a.getBases()[0] == refAllele) continue;
            altAllele = a.getBases()[0];
            break;
        }
        if (altAllele == null) {
            throw new IllegalArgumentException("All alternate alleles match the reference base " + (char)refAllele);
        }
        return refAllele == 65 && altAllele == 71 || refAllele == 71 && altAllele == 65 || refAllele == 67 && altAllele == 84 || refAllele == 84 && altAllele == 67;
    }

    public static class Result {
        final CollectVariantCallingMetrics.VariantCallingSummaryMetrics summary;
        final Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details;

        Result(CollectVariantCallingMetrics.VariantCallingSummaryMetrics summary, Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details) {
            this.summary = summary;
            this.details = details;
        }

        public static Result merge(Collection<Result> results) {
            ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics> details = new ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
            ArrayList<CollectVariantCallingMetrics.VariantCallingSummaryMetrics> summaries = new ArrayList<CollectVariantCallingMetrics.VariantCallingSummaryMetrics>();
            for (Result result : results) {
                summaries.add(result.summary);
                details.addAll(result.details);
            }
            Map<String, Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics>> sampleDetailsMap = CollectionUtil.partition(details, new CollectionUtil.Partitioner<CollectVariantCallingMetrics.VariantCallingDetailMetrics, String>(){

                @Override
                public String getPartition(CollectVariantCallingMetrics.VariantCallingDetailMetrics variantCallingDetailMetrics) {
                    return variantCallingDetailMetrics.SAMPLE_ALIAS;
                }
            });
            ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics> collapsedDetails = new ArrayList<CollectVariantCallingMetrics.VariantCallingDetailMetrics>();
            for (Collection<CollectVariantCallingMetrics.VariantCallingDetailMetrics> sampleDetails : sampleDetailsMap.values()) {
                CollectVariantCallingMetrics.VariantCallingDetailMetrics collapsed = new CollectVariantCallingMetrics.VariantCallingDetailMetrics();
                CollectVariantCallingMetrics.VariantCallingDetailMetrics.foldInto(collapsed, sampleDetails);
                collapsedDetails.add(collapsed);
            }
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics collapsedSummary = new CollectVariantCallingMetrics.VariantCallingSummaryMetrics();
            CollectVariantCallingMetrics.VariantCallingSummaryMetrics.foldInto(collapsedSummary, summaries);
            return new Result(collapsedSummary, collapsedDetails);
        }
    }
}

