/*
 * Decompiled with CFR 0.152.
 */
import htsjdk.samtools.AbstractBAMFileIndex;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;

public class BAMtoIDX {
    private static File BAM = null;
    private static File OUTPUT = null;
    private static int STRAND = 0;
    private static String READ = "READ1";
    private static SamReader inputSam = null;
    private static PrintStream OUT = null;
    private static ArrayList<Integer> BP;
    private static ArrayList<Integer> F_OCC;
    private static ArrayList<Integer> R_OCC;
    private static int CHROMSTOP;

    static {
        CHROMSTOP = -999;
    }

    public static void main(String[] args) {
        BAMtoIDX.loadConfig(args);
        System.out.println(BAMtoIDX.getTimeStamp());
        try {
            OUT = new PrintStream(OUTPUT);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        File f = new File(String.valueOf(BAM.getAbsolutePath()) + ".bai");
        if (f.exists() && !f.isDirectory()) {
            OUT.println("#" + BAMtoIDX.getTimeStamp() + ";" + BAM.getName() + ";" + READ);
            OUT.println("chrom\tindex\tforward\treverse\tvalue");
            if (STRAND == 0) {
                BAMtoIDX.READ1();
            } else if (STRAND == 1) {
                BAMtoIDX.READ2();
            } else if (STRAND == 2) {
                BAMtoIDX.COMBINED();
            }
            OUT.close();
        } else {
            OUT.println("BAI Index File does not exist for: " + BAM.getName() + "\n");
        }
        System.out.println(BAMtoIDX.getTimeStamp());
    }

    public static void addTag(SAMRecord sr) {
        int recordStart = sr.getUnclippedStart();
        if (sr.getReadNegativeStrandFlag()) {
            recordStart = sr.getUnclippedEnd();
        }
        if (recordStart > 0 && recordStart <= CHROMSTOP) {
            if (BP.contains(new Integer(recordStart))) {
                int index = BP.indexOf(new Integer(recordStart));
                if (sr.getReadNegativeStrandFlag()) {
                    R_OCC.set(index, new Integer(R_OCC.get(index) + 1));
                } else {
                    F_OCC.set(index, new Integer(F_OCC.get(index) + 1));
                }
            } else {
                int index = BP.size() - 1;
                if (index >= 0) {
                    while (index >= 0 && recordStart < BP.get(index)) {
                        --index;
                    }
                }
                if (index < BP.size() - 1) {
                    BP.add(index + 1, new Integer(recordStart));
                    if (sr.getReadNegativeStrandFlag()) {
                        R_OCC.add(index + 1, new Integer(1));
                        F_OCC.add(index + 1, new Integer(0));
                    } else {
                        F_OCC.add(index + 1, new Integer(1));
                        R_OCC.add(index + 1, new Integer(0));
                    }
                } else {
                    BP.add(new Integer(recordStart));
                    if (sr.getReadNegativeStrandFlag()) {
                        R_OCC.add(new Integer(1));
                        F_OCC.add(new Integer(0));
                    } else {
                        F_OCC.add(new Integer(1));
                        R_OCC.add(new Integer(0));
                    }
                }
            }
        }
    }

    public static void dumpExcess(String chrom) {
        int trim = 9000;
        while (trim > 0) {
            int sum = F_OCC.get(0) + R_OCC.get(0);
            OUT.println(String.valueOf(chrom) + "\t" + BP.get(0) + "\t" + F_OCC.get(0) + "\t" + R_OCC.get(0) + "\t" + sum);
            BP.remove(0);
            F_OCC.remove(0);
            R_OCC.remove(0);
            --trim;
        }
    }

    public static void READ1() {
        inputSam = SamReaderFactory.makeDefault().open(BAM);
        AbstractBAMFileIndex bai = (AbstractBAMFileIndex)inputSam.indexing().getIndex();
        int numchrom = 0;
        while (numchrom < bai.getNumberOfReferences()) {
            SAMSequenceRecord seq = inputSam.getFileHeader().getSequence(numchrom);
            System.out.println("Processing: " + seq.getSequenceName());
            CHROMSTOP = seq.getSequenceLength();
            BP = new ArrayList();
            F_OCC = new ArrayList();
            R_OCC = new ArrayList();
            SAMRecordIterator iter = inputSam.query(seq.getSequenceName(), 0, seq.getSequenceLength(), false);
            while (iter.hasNext()) {
                SAMRecord sr = (SAMRecord)iter.next();
                if (sr.getReadPairedFlag()) {
                    if (sr.getProperPairFlag() && sr.getFirstOfPairFlag()) {
                        BAMtoIDX.addTag(sr);
                    }
                } else {
                    BAMtoIDX.addTag(sr);
                }
                if (BP.size() <= 10000) continue;
                BAMtoIDX.dumpExcess(seq.getSequenceName());
            }
            iter.close();
            int z = 0;
            while (z < BP.size()) {
                int sum = F_OCC.get(z) + R_OCC.get(z);
                OUT.println(String.valueOf(seq.getSequenceName()) + "\t" + BP.get(z) + "\t" + F_OCC.get(z) + "\t" + R_OCC.get(z) + "\t" + sum);
                ++z;
            }
            ++numchrom;
        }
        bai.close();
    }

    public static void READ2() {
        inputSam = SamReaderFactory.makeDefault().open(BAM);
        AbstractBAMFileIndex bai = (AbstractBAMFileIndex)inputSam.indexing().getIndex();
        int numchrom = 0;
        while (numchrom < bai.getNumberOfReferences()) {
            SAMSequenceRecord seq = inputSam.getFileHeader().getSequence(numchrom);
            System.out.println("Processing: " + seq.getSequenceName());
            CHROMSTOP = seq.getSequenceLength();
            BP = new ArrayList();
            F_OCC = new ArrayList();
            R_OCC = new ArrayList();
            SAMRecordIterator iter = inputSam.query(seq.getSequenceName(), 0, seq.getSequenceLength(), false);
            while (iter.hasNext()) {
                SAMRecord sr = (SAMRecord)iter.next();
                if (sr.getReadPairedFlag() && sr.getProperPairFlag() && !sr.getFirstOfPairFlag()) {
                    BAMtoIDX.addTag(sr);
                }
                if (BP.size() <= 10000) continue;
                BAMtoIDX.dumpExcess(seq.getSequenceName());
            }
            iter.close();
            int x = 0;
            while (x < BP.size()) {
                int sum = F_OCC.get(x) + R_OCC.get(x);
                OUT.println(String.valueOf(seq.getSequenceName()) + "\t" + BP.get(x) + "\t" + F_OCC.get(x) + "\t" + R_OCC.get(x) + "\t" + sum);
                ++x;
            }
            ++numchrom;
        }
        bai.close();
    }

    public static void COMBINED() {
        inputSam = SamReaderFactory.makeDefault().open(BAM);
        AbstractBAMFileIndex bai = (AbstractBAMFileIndex)inputSam.indexing().getIndex();
        int numchrom = 0;
        while (numchrom < bai.getNumberOfReferences()) {
            SAMSequenceRecord seq = inputSam.getFileHeader().getSequence(numchrom);
            System.out.println("Processing: " + seq.getSequenceName());
            CHROMSTOP = seq.getSequenceLength();
            BP = new ArrayList();
            F_OCC = new ArrayList();
            R_OCC = new ArrayList();
            SAMRecordIterator iter = inputSam.query(seq.getSequenceName(), 0, seq.getSequenceLength(), false);
            while (iter.hasNext()) {
                SAMRecord sr = (SAMRecord)iter.next();
                BAMtoIDX.addTag(sr);
                if (BP.size() <= 10000) continue;
                BAMtoIDX.dumpExcess(seq.getSequenceName());
            }
            iter.close();
            int x = 0;
            while (x < BP.size()) {
                int sum = F_OCC.get(x) + R_OCC.get(x);
                OUT.println(String.valueOf(seq.getSequenceName()) + "\t" + BP.get(x) + "\t" + F_OCC.get(x) + "\t" + R_OCC.get(x) + "\t" + sum);
                ++x;
            }
            ++numchrom;
        }
        bai.close();
    }

    public static void loadConfig(String[] command) {
        int i = 0;
        while (i < command.length) {
            switch (command[i].charAt(1)) {
                case 'b': {
                    BAM = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 'o': {
                    OUTPUT = new File(command[i + 1]);
                    ++i;
                    break;
                }
                case 's': {
                    STRAND = Integer.parseInt(command[i + 1]);
                    ++i;
                }
            }
            ++i;
        }
        if (BAM == null) {
            System.out.println("Invalid BAM File!!!\n");
            BAMtoIDX.printUsage();
            System.exit(0);
        }
        if (STRAND > 2 || STRAND < 0) {
            System.out.println("Invalid Strand Output!!!\n");
            BAMtoIDX.printUsage();
            System.exit(0);
        }
        if (STRAND == 0) {
            READ = "READ1";
        } else if (STRAND == 1) {
            READ = "READ2";
        } else if (STRAND == 2) {
            READ = "COMBINED";
        }
        if (OUTPUT == null) {
            OUTPUT = new File(String.valueOf(BAM.getName().split("\\.")[0]) + "_" + READ + ".scidx");
        }
        System.out.println("-----------------------------------------\nCommand Line Arguments:");
        System.out.println("BAM file: " + BAM);
        System.out.println("Output: " + OUTPUT);
        System.out.println("Output Read: " + READ);
    }

    public static void printUsage() {
        System.out.println("Usage: java -jar BAMtoIDX.jar -b [BAMFile] -o [OutputFile] -s [Read]");
        System.out.println("-----------------------------------------");
        System.out.println("Required: BAM file must be sorted and BAI index must be in same folder as BAM file.");
        System.out.println("\nRequired Parameter:");
        System.out.println("BAM File:\t\t-b\t\tBAM file");
        System.out.println("\nOptional Parameters:");
        System.out.println("Output File Name:\t-o\t\tOutput file");
        System.out.println("Read to Output:\t\t-s\t\t0,1,2 (Read1 = 0[Default], Read2 = 1, Combined = 2)");
    }

    private static String getTimeStamp() {
        Date date = new Date();
        String time = new Timestamp(date.getTime()).toString();
        return time;
    }
}

