#!/usr/bin/env Rscript

initial.options <- commandArgs(trailingOnly = FALSE)
script_parent_dir <- dirname(sub("--file=", "", initial.options[grep("--file=", initial.options)]))

## begin warning handler
withCallingHandlers({

library(methods) # Because Rscript does not always do this

options('useFancyQuotes' = FALSE)

suppressPackageStartupMessages(library("optparse"))
suppressPackageStartupMessages(library("RGalaxy"))


option_list <- list()

option_list$bam <- make_option('--bam', type='character')
option_list$bai <- make_option('--bai', type='character')
option_list$vcf <- make_option('--vcf', type='character')
option_list$exon_anno <- make_option('--exon_anno', type='character')
option_list$proteinseq <- make_option('--proteinseq', type='character')
option_list$procodingseq <- make_option('--procodingseq', type='character')
option_list$ids <- make_option('--ids', type='character')
option_list$rpkmCutoff <- make_option('--rpkmCutoff', type='character')
option_list$outputFile <- make_option('--outputFile', type='character')


opt <- parse_args(OptionParser(option_list=option_list))


customProDB <- function(
	bam_file = GalaxyInputFile(required=TRUE), 
	bai_file = GalaxyInputFile(required=TRUE), 
	vcf_file = GalaxyInputFile(required=TRUE), 
	exon_anno_file = GalaxyInputFile(required=TRUE),
	proteinseq_file = GalaxyInputFile(required=TRUE),
	procodingseq_file = GalaxyInputFile(required=TRUE),
	rpkmCutoff = GalaxyNumericParam(required=TRUE),
	ids_file = GalaxyInputFile(required=TRUE),
	outputFile = GalaxyOutput("FASTA","fasta"))
{
    file.symlink(exon_anno_file, paste(dirname(exon_anno_file), "exon_anno.RData", sep="/"))
    file.symlink(proteinseq_file, paste(dirname(exon_anno_file), "proseq.RData", sep="/"))
    file.symlink(procodingseq_file, paste(dirname(exon_anno_file), "procodingseq.RData", sep="/"))
    file.symlink(ids_file, paste(dirname(exon_anno_file), "ids.RData", sep="/"))
    
    bamLink = paste(dirname(bam_file), "input.bam", sep="/")
    file.symlink(bam_file, bamLink)
    file.symlink(bai_file, paste(bamLink, ".bai", sep=""))

    suppressPackageStartupMessages(library(customProDB))

    easyRun(bamFile=bamLink, vcfFile=vcf_file, annotation_path=dirname(exon_anno_file),
            rpkm_cutoff=rpkmCutoff, outfile_path=".", outfile_name="output",
            nov_junction=F, INDEL=T, lablersid=F, COSMIC=F)
}


params <- list()
for(param in names(opt))
{
    if (!param == "help")
        params[param] <- opt[param]
}

setClass("GalaxyRemoteError", contains="character")
wrappedFunction <- function(f)
{
    tryCatch(do.call(f, params),
        error=function(e) new("GalaxyRemoteError", conditionMessage(e)))
}


suppressPackageStartupMessages(library(RGalaxy))
do.call(customProDB, params)

## end warning handler
}, warning = function(w) {
    cat(paste("Warning:", conditionMessage(w), "\n"))
    invokeRestart("muffleWarning")
})
