#!/usr/bin/env Rscript

initial.options <- commandArgs(trailingOnly = FALSE)
script_parent_dir <- dirname(sub("--file=", "", initial.options[grep("--file=", initial.options)]))

## begin warning handler
withCallingHandlers({

library(methods) # Because Rscript does not always do this

options('useFancyQuotes' = FALSE)

suppressPackageStartupMessages(library("optparse"))
suppressPackageStartupMessages(library("RGalaxy"))


option_list <- list()

option_list$bam <- make_option('--bam', type='character')
option_list$vcf <- make_option('--vcf', type='character')
option_list$exon_anno <- make_option('--exon_anno', type='character')
option_list$proteinseq <- make_option('--proteinseq', type='character')
option_list$procodingseq <- make_option('--procodingseq', type='character')
option_list$outputFile <- make_option('--outputFile', type='character')


opt <- parse_args(OptionParser(option_list=option_list))


customProDB <- function(
	bam_file = GalaxyInputFile(required=TRUE), 
	vcf_file = GalaxyInputFile(required=TRUE), 
	exon_anno_file = GalaxyInputFile(required=TRUE),
	proteinseq_file = GalaxyInputFile(required=TRUE),
	procodingseq_file = GalaxyInputFile(required=TRUE),
	outputFile = GalaxyOutput("FASTA","fasta"))
{
    if (dirname(exon_anno_file) != dirname(proteinseq_file) ||
        dirname(exon_anno_file) != dirname(procodingseq_file))
    {
        gstop("parent directory of annotation files must all be the same")
    }

    if (file.exists(outputFile))
    {
        if (file.info(outputFile)$size > 0) { gstop("output file already exists") }
        else
        {
            tryCatch(
            {
                file.remove(outputFile)
            }, error=function(err)
            {
                gstop("failed to remove empty existing file")
            })
        }
    }

    suppressPackageStartupMessages(library(customProDB))

    easyRun(bamFile=bamFile, vcfFile=vcfFile, annotation_path=dirname(exon_anno_file), outfile_path=dirname(outputFile), outfile_name=basename(outputFile))
}


params <- list()
for(param in names(opt))
{
    if (!param == "help")
        params[param] <- opt[param]
}

setClass("GalaxyRemoteError", contains="character")
wrappedFunction <- function(f)
{
    tryCatch(do.call(f, params),
        error=function(e) new("GalaxyRemoteError", conditionMessage(e)))
}


suppressPackageStartupMessages(library(RGalaxy))
do.call(customProDB, params)

## end warning handler
}, warning = function(w) {
    cat(paste("Warning:", conditionMessage(w), "\n"))
    invokeRestart("muffleWarning")
})
