#!/usr/bin/perl -w
use Cwd;
use strict;

my %arguments=
(
"fileR"=>"",		    #file: vcf file of affected individuals
"fileC"=>"",		    #file: vcf file of unaffected individuals
"ofile"=>"",		    #name: name of the output files
"AD"=>"T",
"XL"=>"F",		    #
"disease_clinvar"=>[4,6],   #numeric mandadory, multiple values
"score_AF"=>[2,4],          #numeric mandatory, multiple values
"score_functional"=>[4,6],  #numeric mandatory, multiple values
"score_NS"=>[2,4],          #numeric mandatory, multiple values
"score_nIND"=>[2,4],        #numeric mandatory, multiple values
"scoreeQTL"=>[2,4],         #numeric mandatory, multiple values
"scoreG"=>[3,5],            #numeric  mandatory, multiple values
"scoreI"=>[0.1..0.3],
"disease"=>"",          #name   optional
"similarD"=>"",         #file optional
"lgenes"=>"",           #file optional
"leQTL"=>"qfile",       #file   mandatory, but default value
"keywords"=>"kfile",    #file   mandatory, but default value
"effects"=>"efile",     #file   mandatory, but default value
"ifile"=>"inter_Hs.file",
"nind"=>5,
"AF"=>0.0001
);

my @arguments=@ARGV;
for (my $i=0;$i<=$#ARGV;$i+=2)
{
        my $act=$ARGV[$i];
        $act=~s/-//g;
        my $val=$ARGV[$i+1];
        if (exists $arguments{$act})
        {
		unless ($val=~/\:/)
		{
                	$arguments{$act}=$val;
		}else{
			my ($s,$e)=(split(/\:/,$val));
			my $increment= $s=~/\./ ? 0.1 : 1;
			my @vls=();
			for (my $I=$s;$I<=$e;$I+=$increment)
			{
				push(@vls,$I);
			}
			$arguments{$act}=\@vls;
		}
        }else{
                warn("$act: unknown argument\n");
                my @valid=keys %arguments;
                warn("Valid arguments are @valid\n");
                die("All those moments will be lost in time, like tears in rain.\n Time to die!\n");
        }
        #print "$act $val\n";
}

my %compose_ARG=
(
        "disease"=>1,          #name   optional
        "similarD"=>1,         #file optional
        "lgenes"=>1,           #file optional
        "leQTL"=>1,       #file   mandatory, but default value
        "keywords"=>1,    #file   mandatory, but default value
        "effects"=>1,     #file
	"AF"=>1,
	"nind"=>1,
	"AD"=>1,
	"XL"=>1,
	"ifile"=>1

);

my $dir=getcwd();
my $add_string=" ";

foreach my $a (keys %compose_ARG)
{
	$add_string.="-$a $arguments{$a} " if $arguments{$a} ne "";
}


my @DC=@{$arguments{"disease_clinvar"}};	#=>[2..8],   #numeric mandadory, but default value
my @AF=@{$arguments{"score_AF"}};          #numeric mandatory, but default value
my @FUN=@{$arguments{"score_functional"}};	#=>[2..8],  #numeric mandatory, but default value
my @NS=@{$arguments{"score_NS"}};		#=>[2..8],          #numeric mandatory, but default value
my @NI=@{$arguments{"score_nIND"}};	#=>[2..8],        #numeric mandatory, but default value
my @Q=@{$arguments{"scoreeQTL"}};        	#numeric mandatory, but default value
my @G=@{$arguments{"scoreG"}};		#=>[1..3],            #numeric  mandatory, but default value
my @I=@{$arguments{"scoreI"}};

my $Rfile=$arguments{"fileR"};
my $Tfile=$arguments{"fileC"};
my $Ofile=$arguments{"ofile"};

#print "@DC\n @AF\n @FUN\n @NS\n @NI\n @Q\n @G\n @I\n";

open(O,">$Ofile");
print O "score_DB\tscore_RV\tscore_FE\tscore_NS\tscore_OR\tscore_eQ\tscore_AD\tScore_DG\tCut_Off\tPos_Affected\tPos_Healthy\tPvalue\tFold_change\n";


my $commandR="perl $dir/score_complete_alt_M.pl -vcf $dir/$Rfile -ofile $dir/R.csv  -ovcfile $dir/R.vcf  $add_string";
my $commandT="perl $dir/score_complete_alt_M.pl -vcf $dir/$Tfile -ofile $dir/T.csv  -ovcfile $dir/T.vcf  $add_string";
my %ODATA=();

foreach my $dc (@DC)
{

	foreach my $af (@AF)
	{

		foreach my $fun (@FUN)
		{

			foreach my $ns (@NS)
			{

				foreach my $ni (@NI)
				{
					

					foreach my $Q (@Q)
					{
						foreach my $G (@G)
						{
							foreach my $I (@I)
							{
							$commandR.="-score_AF $af ";
                					$commandT.="-score_AF $af ";
							$commandR.="-score_functional $fun ";
                        				$commandT.="-score_functional $fun ";
							$commandR.="-score_NS $ns ";
                                			$commandT.="-score_NS $ns ";
							$commandR.="-score_nIND $ni ";
                                        		$commandT.="-score_nIND $ni ";
							$commandR.="-scoreeQTL $Q ";
                                                	$commandT.="-scoreeQTL $Q ";
							$commandR.="-disease_clinvar $dc ";
        						$commandT.="-disease_clinvar $dc ";
							$commandR.="-scoreG $G ";
                                        		$commandT.="-scoreG $G ";
							$commandR.="-scoreI $I ";
                                                        $commandT.="-scoreI $I ";

							system($commandR)==0||die("Non giro Rfile");
							system($commandT)==0||die("Non giro Tfile");
							$commandR="perl $dir/score_complete_alt_M.pl -vcf $dir/$Rfile -ofile $dir/R.csv  -ovcfile $dir/R.vcf  $add_string";
							$commandT="perl $dir/score_complete_alt_M.pl -vcf $dir/$Tfile -ofile $dir/T.csv  -ovcfile $dir/T.vcf  $add_string";
				my $r=`Rscript --vanilla $dir/wilcox.R $dir/R.csv $dir/T.csv`;
							my $PV=(split(/\t/,$r))[3];
							push(@{$ODATA{$PV}},"$dc\t$af\t$fun\t$ns\t$ni\t$Q\t$G\t$I\t$r\n");
							}
						}
					}
				}
			}
		}
	}
}

foreach my $O (sort {$a<=>$b} keys %ODATA)
{
	my @values=@{$ODATA{$O}};
	foreach my $v (@values)
	{
		print O "$v";
	}
}
