#!/usr/bin/perl -w
use Cwd;

%arguments=
(
"fileR"=>"",		    #file: vcf file of affected individuals
"fileC"=>"",		    #file: vcf file of unaffected individuals
"ofile"=>"",		    #name: name of the output files
"AD"=>"T",
"XL"=>"F",		    #
"disease_clinvar"=>[4,6],   #numeric mandadory, multiple values
"score_AF"=>[2,4],          #numeric mandatory, multiple values
"score_functional"=>[4,6],  #numeric mandatory, multiple values
"score_NS"=>[2,4],          #numeric mandatory, multiple values
"score_nIND"=>[2,4],        #numeric mandatory, multiple values
"scoreeQTL"=>[2,4],         #numeric mandatory, multiple values
"scoreG"=>[3,5],            #numeric  mandatory, multiple values
"scoreI"=>[1..3],
"disease"=>"",          #name   optional
"similarD"=>"",         #file optional
"lgenes"=>"",           #file optional
"leQTL"=>"qfile",       #file   mandatory, but default value
"keywords"=>"kfile",    #file   mandatory, but default value
"effects"=>"efile",     #file   mandatory, but default value
"ifile"=>"inter_Hs.file"
"nind"=>5,
"AF"=>0.0001
);

@arguments=@ARGV;
for ($i=0;$i<=$#ARGV;$i+=2)
{
        $act=$ARGV[$i];
        $act=~s/-//g;
        $val=$ARGV[$i+1];
        if (exists $arguments{$act})
        {
		unless ($val=~/\:/)
		{
                	$arguments{$act}=$val;
		}else{
			($s,$e)=(split(/\:/,$val));
			@vls=();
			print "$s $e\n";
			for ($I=$s;$I<=$e;$I++)
			{
				push(@vls,$I);
			}
			print "@vls\n";
			$arguments{$act}=\@vls;
		}
        }else{
                warn("$act: unknown argument\n");
                @valid=keys %arguments;
                warn("Valid arguments are @valid\n");
                die("All those moments will be lost in time, like tears in rain.\n Time to die!\n");
        }
        #print "$act $val\n";
}

%compose_ARG=
(
        "disease"=>1,          #name   optional
        "similarD"=>1,         #file optional
        "lgenes"=>1,           #file optional
        "leQTL"=>1,       #file   mandatory, but default value
        "keywords"=>1,    #file   mandatory, but default value
        "effects"=>1,     #file
	"AF"=>1,
	"nind"=>1,
	"AD"=>1,
	"XL"=>1,
	"ifile"=>1

);

$dir=getcwd();
print "$dir\n";
$add_string=" ";

foreach $a (keys %compose_ARG)
{
	$add_string.="-$a $arguments{$a} " if $arguments{$a} ne "";
}

#print "$add_string";


@DC=@{$arguments{"disease_clinvar"}};	#=>[2..8],   #numeric mandadory, but default value
@AF=@{$arguments{"score_AF"}};          #numeric mandatory, but default value
@FUN=@{$arguments{"score_functional"}};	#=>[2..8],  #numeric mandatory, but default value
@NS=@{$arguments{"score_NS"}};		#=>[2..8],          #numeric mandatory, but default value
@NI=@{$arguments{"score_nIND"}};	#=>[2..8],        #numeric mandatory, but default value
@Q=@{$arguments{"scoreeQTL"}};        	#numeric mandatory, but default value
@G=@{$arguments{"scoreG"}};		#=>[1..3],            #numeric  mandatory, but default value
@I=@{$arguments{"scoreI"}};

$Rfile=$arguments{"fileR"};
$Tfile=$arguments{"fileC"};
$Ofile=$arguments{"ofile"};
open(O,">$Ofile");
print O "disease_clinvar\tscore_AF\tscore_functional\tscore_NS\tscore_nIND\tscoreeQTL\tscoreG\tCut_off\tPosD\tPosH\tPvalue\tFold_change\n";
$commandR="perl $dir/score_complete_alt_M.pl -vcf $dir/$Rfile -ofile $dir/R.csv  -ovcfile $dir/R.vcf  $add_string";
$commandT="perl $dir/score_complete_alt_M.pl -vcf $dir/$Tfile -ofile $dir/T.csv  -ovcfile $dir/T.vcf  $add_string";


foreach $dc (@DC)
{

	foreach $af (@AF)
	{

		foreach $fun (@FUN)
		{

			foreach $ns (@NS)
			{

				foreach $ni (@NI)
				{
					

					foreach $Q (@Q)
					{
						foreach $G (@G)
						{
							foreach $I (@I)
							{
							$commandR.="-score_AF $af ";
                					$commandT.="-score_AF $af ";
							$commandR.="-score_functional $fun ";
                        				$commandT.="-score_functional $fun ";
							$commandR.="-score_NS $ns ";
                                			$commandT.="-score_NS $ns ";
							$commandR.="-score_nIND $ni ";
                                        		$commandT.="-score_nIND $ni ";
							$commandR.="-scoreeQTL $Q ";
                                                	$commandT.="-scoreeQTL $Q ";
							$commandR.="-disease_clinvar $dc ";
        						$commandT.="-disease_clinvar $dc ";
							$commandR.="-scoreG $G ";
                                        		$commandT.="-scoreG $G ";
							$commandR.="-scoreI $I ";
                                                        $commandT.="-scoreI $I ";

							#print "$commandR\n$commandT\n";
							system($commandR)==0||die("Non giro Rfile");
							system($commandT)==0||die("Non giro Tfile");
							$commandR="perl $dir/score_complete_alt_M.pl -vcf $dir/$Rfile -ofile $dir/R.csv  -ovcfile $dir/R.vcf  $add_string";
							$commandT="perl $dir/score_complete_alt_M.pl -vcf $dir/$Tfile -ofile $dir/T.csv  -ovcfile $dir/T.vcf  $add_string";

							$r=`Rscript --vanilla $dir/survival_optM.R $dir/R.csv $dir/T.csv`;
							
							print O "$dc\t$af\t$fun\t$ns\t$ni\t$Q\t$G\t$r\n";
							}
							#die();
						}
					}
				}
			}
		}
	}
}
