#!/bin/bash

if [ $# -ne 7 ]
then
    echo "ERROR: Expected exactly 7 arguments; got: $*" 1>&2
    exit 1
fi

# GET ARGS
LABEL=$1; shift
FASTA_INFILE=$1; shift
QUAL_INFILE=$1; shift
FASTA_OUTFILE=$1; shift
QUAL_OUTFILE=$1; shift
SINGLETS_OUTFILE=$1; shift
DIR=$1; shift

if [ ! -e $FASTA_INFILE ]
then
    echo "Fasta infile not found: $FASTA_INFILE" 1>&2
    exit 1
fi

# ALL FILES GO IN THIS extra_files_path
mkdir $DIR
cd $DIR
ln -s $FASTA_INFILE ./$LABEL
if [ $QUAL_INFILE != 'None' ]
then
    ln -s $QUAL_INFILE ./$LABEL.qual
fi

# RUN COMMAND
phrap $LABEL 1> phrap.stdout 2> phrap.stderr
if [ $? -ne 0 ]
then
    echo "COMMAND FAILURE; LOG:" 1>&2
    cat phrap.stderr 1>&2
    exit $?
fi

# SYMLINK OUTFILES
link () { # args: src, dest
    # if dest defined and src exist, then create symlink
    if [[ $2 != 'None' && -e "$1" ]]
    then
        if [ -e $2 ]
        then
            rm $2
        fi
        ln -s $1 $2
    fi
}
link $DIR/$LABEL.contigs $FASTA_OUTFILE
link $DIR/$LABEL.contigs.qual $QUAL_OUTFILE
link $DIR/$LABEL.singlets $SINGLETS_OUTFILE
