"""
BLAST Database classes
"""

import data
import logging
import re
import string
from cgi import escape
from galaxy.datatypes.metadata import MetadataElement
from galaxy.datatypes import metadata
import galaxy.model
from galaxy import util
from sniff import *

log = logging.getLogger(__name__)

class BlastDb( data.Data ):
    """Class for BLAST database files"""

    file_ext = 'blastdb'
    composite_type='basic'

    MetadataElement( readonly=True, optional=True, visible=False, no_value=0 )

    def __init__(self,**kwd):
        data.Data.__init__(self, **kwd)
        self.add_composite_file('blastdb.nhr')
        self.add_composite_file('blastdb.nin')
        self.add_composite_file('blastdb.nsq')
        self.add_composite_file('blastdb.nhd', optional=True)
        self.add_composite_file('blastdb.nsi', optional=True)
        self.add_composite_file('blastdb.nhi', optional=True)
        self.add_composite_file('blastdb.nog', optional=True)
        self.add_composite_file('blastdb.nsd', optional=True)
    def set_peek( self, dataset, is_multi_byte=False ):
        if not dataset.dataset.purged:
            dataset.peek  = "Folder of multiple files"
            dataset.blurb = "Folder of multiple files"
        else:
            dataset.peek = 'file does not exist'
            dataset.blurb = 'file purged from disk'
    def display_peek( self, dataset ):
        try:
            return dataset.peek
        except:
            return "Folder of multiple files"
    def get_mime(self):
        """Returns the mime type of the datatype"""
        return 'text/plain'
