#!/usr/bin/env Rscript

suppressMessages(
  library(ggtree)
)

args = commandArgs(trailingOnly=TRUE)

tree <- read.tree(args[1])

tree_plot <- ggplot(tree, aes(x, y)) + 
  geom_tree() + 
  theme_tree2() +
  geom_tiplab(align=TRUE)

suppressMessages(
  ggsave(args[2], plot=tree_plot, device="png")
)
